/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.xml.collector;

import java.io.File;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import org.opennms.netmgt.collection.api.CollectionAttribute;
import org.opennms.netmgt.collection.api.CollectionResource;
import org.opennms.netmgt.collection.api.CollectionSet;
import org.opennms.netmgt.collection.api.CollectionSetVisitor;
import org.opennms.netmgt.collection.support.AbstractCollectionSetVisitor;
import org.opennms.protocols.xml.collector.AbstractXmlCollectorTest;

public class NodeLevelDataTest
extends AbstractXmlCollectorTest {
    @Override
    public String getXmlConfigFileName() {
        return "src/test/resources/node-level-datacollection-config.xml";
    }

    @Override
    public String getXmlSampleFileName() {
        return "src/test/resources/node-level.xml";
    }

    @Test
    public void testDefaultXmlCollector() throws Exception {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("collection", "NodeLevel");
        parameters.put("handler-class", "org.opennms.protocols.xml.collector.MockDefaultXmlCollectionHandler");
        CollectionSet collectionSet = this.executeCollectorTest(parameters, 1);
        CountVisitor visitor = new CountVisitor();
        collectionSet.visit((CollectionSetVisitor)visitor);
        Assert.assertEquals((long)1L, (long)visitor.getResourceCount());
        Assert.assertEquals((long)6L, (long)visitor.getAttributeCount());
        File file = new File("target/snmp/1/node-level-stats.jrb");
        Assert.assertTrue((boolean)file.exists());
        String[] dsnames = new String[]{"v1", "v2", "v3", "v4", "v5", "v6"};
        Double[] dsvalues = new Double[]{10.0, 11.0, 12.0, 13.0, 14.0, 15.0};
        this.validateJrb(file, dsnames, dsvalues);
    }

    private static class CountVisitor
    extends AbstractCollectionSetVisitor {
        private int resourceCount = 0;
        private int attributeCount = 0;

        private CountVisitor() {
        }

        public void visitResource(CollectionResource resource) {
            ++this.resourceCount;
        }

        public void visitAttribute(CollectionAttribute attribute) {
            ++this.attributeCount;
        }

        public int getResourceCount() {
            return this.resourceCount;
        }

        public int getAttributeCount() {
            return this.attributeCount;
        }
    }
}

