/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.xml.collector;

import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.opennms.netmgt.collection.api.AttributeGroupType;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionException;
import org.opennms.netmgt.model.OnmsAssetRecord;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.protocols.xml.collector.AbstractXmlCollectionHandler;
import org.opennms.protocols.xml.collector.XmlCollectionResource;
import org.opennms.protocols.xml.collector.XmlCollectionSet;
import org.opennms.protocols.xml.config.Request;
import org.opennms.protocols.xml.config.XmlDataCollection;
import org.opennms.protocols.xml.config.XmlSource;

public class AbstractXmlCollectionHandlerTest {
    @Test
    public void testParseString() throws Exception {
        AbstractXmlCollectionHandler handler = new AbstractXmlCollectionHandler(){

            public XmlCollectionSet collect(CollectionAgent agent, XmlDataCollection collection, Map<String, Object> parameters) throws CollectionException {
                return null;
            }

            protected void processXmlResource(XmlCollectionResource collectionResource, AttributeGroupType attribGroupType) {
            }

            protected void fillCollectionSet(String urlString, Request request, CollectionAgent agent, XmlCollectionSet collectionSet, XmlSource source) throws Exception {
            }
        };
        OnmsNode node = new OnmsNode();
        node.setId(Integer.valueOf(1));
        node.setLabel("mynode.local");
        OnmsAssetRecord asset = new OnmsAssetRecord();
        asset.setSerialNumber("1001");
        node.setAssetRecord(asset);
        String url = handler.parseString("URL", "http://{nodeLabel}/{ipAddress}/serial/{serialNumber}/{step}", node, "127.0.0.1", Integer.valueOf(300));
        Assert.assertEquals((Object)"http://mynode.local/127.0.0.1/serial/1001/300", (Object)url);
        String multiline = "<data>\n   <source label='{nodeLabel}'/>\n</data>";
        String xml = handler.parseString("Content", multiline, node, "127.0.0.1", Integer.valueOf(300));
        Assert.assertEquals((Object)"<data>\n   <source label='mynode.local'/>\n</data>", (Object)xml);
    }
}

