/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.json.collector;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import net.sf.json.JSONObject;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.Pointer;
import org.junit.Assert;
import org.junit.Test;
import org.opennms.protocols.json.collector.AbstractJsonCollectorTest;
import org.opennms.protocols.json.collector.MockDocumentBuilder;

public class JsonCollectorSolarisZonesTest
extends AbstractJsonCollectorTest {
    @Override
    public String getJSONConfigFileName() {
        return "src/test/resources/solaris-zones-datacollection-config.xml";
    }

    @Override
    public String getJSONSampleFileName() {
        return "src/test/resources/solaris-zones.json";
    }

    @Test
    public void testXpath() throws Exception {
        JSONObject json = MockDocumentBuilder.getJSONDocument();
        JXPathContext context = JXPathContext.newContext((Object)json);
        Iterator itr = context.iteratePointers("/zones/zone");
        while (itr.hasNext()) {
            Pointer resPtr = (Pointer)itr.next();
            JXPathContext relativeContext = context.getRelativeContext(resPtr);
            String resourceName = (String)relativeContext.getValue("@name");
            Assert.assertNotNull((Object)resourceName);
            String value = (String)relativeContext.getValue("parameter[@key='nproc']/@value");
            Assert.assertNotNull((Object)Integer.valueOf(value));
        }
    }

    @Test
    public void testDefaultJsonCollector() throws Exception {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("collection", "Solaris");
        parameters.put("handler-class", "org.opennms.protocols.json.collector.MockDefaultJsonCollectionHandler");
        this.executeCollectorTest(parameters, 3);
        Assert.assertTrue((boolean)new File("target/snmp/1/solarisZoneStats/global/solaris-zone-stats.jrb").exists());
        Assert.assertTrue((boolean)new File("target/snmp/1/solarisZoneStats/zone1/solaris-zone-stats.jrb").exists());
        Assert.assertTrue((boolean)new File("target/snmp/1/solarisZoneStats/zone2/solaris-zone-stats.jrb").exists());
        File file = new File("target/snmp/1/solarisZoneStats/global/solaris-zone-stats.jrb");
        String[] dsnames = new String[]{"nproc", "nlwp", "pr_size", "pr_rssize", "pctmem", "pctcpu"};
        Double[] dsvalues = new Double[]{245.0, 1455.0, 2646864.0, 1851072.0, 0.7, 0.24};
        this.validateJrb(file, dsnames, dsvalues);
        file = new File("target/snmp/1/solarisZoneStats/zone1/solaris-zone-stats.jrb");
        dsnames = new String[]{"nproc", "nlwp", "pr_size", "pr_rssize", "pctmem", "pctcpu"};
        dsvalues = new Double[]{24.0, 328.0, 1671128.0, 1193240.0, 0.4, 0.07};
        this.validateJrb(file, dsnames, dsvalues);
        file = new File("target/snmp/1/solarisZoneStats/zone2/solaris-zone-stats.jrb");
        dsnames = new String[]{"nproc", "nlwp", "pr_size", "pr_rssize", "pctmem", "pctcpu"};
        dsvalues = new Double[]{124.0, 1328.0, 1571128.0, 193240.0, 0.5, 0.06};
        this.validateJrb(file, dsnames, dsvalues);
    }
}

