/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.json.collector;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.easymock.EasyMock;
import org.jrobin.core.Datasource;
import org.jrobin.core.RrdDb;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.opennms.core.test.MockLogAppender;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionSet;
import org.opennms.netmgt.collection.api.CollectionSetVisitor;
import org.opennms.netmgt.collection.api.ServiceParameters;
import org.opennms.netmgt.collection.persistence.rrd.GroupPersister;
import org.opennms.netmgt.events.api.EventProxy;
import org.opennms.netmgt.rrd.RrdRepository;
import org.opennms.protocols.json.collector.MockDocumentBuilder;
import org.opennms.protocols.xml.collector.XmlCollector;
import org.opennms.protocols.xml.config.XmlRrd;
import org.opennms.protocols.xml.dao.XmlDataCollectionConfigDao;
import org.opennms.protocols.xml.dao.jaxb.XmlDataCollectionConfigDaoJaxb;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public abstract class AbstractJsonCollectorTest {
    private static final String TEST_SNMP_DIRECTORY = "target/snmp/";
    private CollectionAgent m_collectionAgent;
    private EventProxy m_eventProxy;
    private XmlDataCollectionConfigDaoJaxb m_xmlCollectionDao;

    @Before
    public void setUp() throws Exception {
        FileUtils.deleteDirectory((File)new File(TEST_SNMP_DIRECTORY));
        MockLogAppender.setupLogging();
        System.setProperty("org.opennms.rrd.usetcp", "false");
        System.setProperty("org.opennms.rrd.usequeue", "false");
        System.setProperty("org.opennms.rrd.strategyClass", "org.opennms.netmgt.rrd.jrobin.JRobinRrdStrategy");
        this.m_collectionAgent = (CollectionAgent)EasyMock.createMock(CollectionAgent.class);
        EasyMock.expect((Object)this.m_collectionAgent.getNodeId()).andReturn((Object)1).anyTimes();
        EasyMock.expect((Object)this.m_collectionAgent.getHostAddress()).andReturn((Object)"127.0.0.1").anyTimes();
        EasyMock.expect((Object)this.m_collectionAgent.getStorageDir()).andReturn((Object)new File(String.valueOf(1))).anyTimes();
        this.m_eventProxy = (EventProxy)EasyMock.createMock(EventProxy.class);
        this.m_xmlCollectionDao = new XmlDataCollectionConfigDaoJaxb();
        FileSystemResource resource = new FileSystemResource(this.getJSONConfigFileName());
        this.m_xmlCollectionDao.setConfigResource((Resource)resource);
        this.m_xmlCollectionDao.afterPropertiesSet();
        MockDocumentBuilder.setJSONFileName(this.getJSONSampleFileName());
        EasyMock.replay((Object[])new Object[]{this.m_collectionAgent, this.m_eventProxy});
    }

    public XmlDataCollectionConfigDaoJaxb getConfigDao() {
        return this.m_xmlCollectionDao;
    }

    public abstract String getJSONSampleFileName();

    public abstract String getJSONConfigFileName();

    @After
    public void tearDown() throws Exception {
        EasyMock.verify((Object[])new Object[]{this.m_collectionAgent, this.m_eventProxy});
        MockLogAppender.assertNoWarningsOrGreater();
    }

    public void executeCollectorTest(Map<String, Object> parameters, int expectedFiles) throws Exception {
        XmlCollector collector = new XmlCollector();
        collector.setXmlCollectionDao((XmlDataCollectionConfigDao)this.m_xmlCollectionDao);
        collector.initialize(this.m_collectionAgent, parameters);
        CollectionSet collectionSet = collector.collect(this.m_collectionAgent, this.m_eventProxy, parameters);
        collector.release(this.m_collectionAgent);
        Assert.assertEquals((long)1L, (long)collectionSet.getStatus());
        ServiceParameters serviceParams = new ServiceParameters(new HashMap());
        GroupPersister persister = new GroupPersister(serviceParams, this.createRrdRepository((String)parameters.get("collection")));
        collectionSet.visit((CollectionSetVisitor)persister);
        Assert.assertEquals((long)expectedFiles, (long)FileUtils.listFiles((File)new File(TEST_SNMP_DIRECTORY), (String[])new String[]{"jrb"}, (boolean)true).size());
    }

    public void validateJrb(File file, String[] dsnames, Double[] dsvalues) throws Exception {
        Assert.assertTrue((boolean)file.exists());
        RrdDb jrb = new RrdDb(file);
        Assert.assertEquals((long)dsnames.length, (long)jrb.getDsCount());
        for (int i = 0; i < dsnames.length; ++i) {
            Datasource ds = jrb.getDatasource(dsnames[i]);
            Assert.assertNotNull((Object)ds);
            Assert.assertEquals((Object)dsvalues[i], (Object)ds.getLastValue());
        }
    }

    private RrdRepository createRrdRepository(String collection) throws IOException {
        XmlRrd rrd = this.m_xmlCollectionDao.getDataCollectionByName(collection).getXmlRrd();
        RrdRepository repository = new RrdRepository();
        repository.setRrdBaseDir(new File(TEST_SNMP_DIRECTORY));
        repository.setHeartBeat(rrd.getStep() * 2);
        repository.setStep(rrd.getStep().intValue());
        repository.setRraList(rrd.getXmlRras());
        return repository;
    }
}

