/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.http;

import java.io.IOException;
import java.io.Reader;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.protocols.http.SampleData;
import org.opennms.protocols.xml.config.Person;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestServlet
extends HttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(TestServlet.class);

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        LOG.info("JUnit Test Request: %s", (Object)req.getRequestURI());
        LOG.info("JUnit Test Content Type: %s", (Object)req.getContentType());
        String requestContent = IOUtils.toString((Reader)req.getReader());
        if (req.getRequestURI().equals("/junit/test/sample")) {
            resp.getWriter().write("OK!");
        }
        if (req.getRequestURI().equals("/junit/test/post")) {
            if (req.getContentType().startsWith("application/xml")) {
                resp.setContentType("application/xml");
                Person p = (Person)JaxbUtils.unmarshal(Person.class, (String)requestContent);
                SampleData data = new SampleData();
                data.addParameter("firstName", p.getFirstName());
                data.addParameter("lastName", p.getLastName());
                resp.getWriter().write(JaxbUtils.marshal((Object)data));
            } else if (req.getContentType().startsWith("application/json")) {
                resp.setContentType("application/json");
                JSONObject object = JSONObject.fromObject((Object)requestContent);
                SampleData data = new SampleData();
                data.addParameter("firstName", object.getJSONObject("person").getString("firstName"));
                data.addParameter("lastName", object.getJSONObject("person").getString("lastName"));
                resp.getWriter().write(JaxbUtils.marshal((Object)data));
            } else if (req.getContentType().startsWith("application/x-www-form-urlencoded")) {
                resp.setContentType("application/xml");
                StringTokenizer st = new StringTokenizer(requestContent, "&");
                SampleData data = new SampleData();
                while (st.hasMoreTokens()) {
                    String[] pair = st.nextToken().split("=");
                    data.addParameter(pair[0], pair[1]);
                }
                resp.getWriter().write(JaxbUtils.marshal((Object)data));
            } else {
                resp.setContentType("text/plain");
                resp.getWriter().write("ERROR!");
            }
        }
    }
}

