/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.http;

import java.io.Closeable;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.test.http.JUnitHttpServerExecutionListener;
import org.opennms.core.test.http.annotations.JUnitHttpServer;
import org.opennms.core.test.http.annotations.Webapp;
import org.opennms.core.web.HttpClientWrapper;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.protocols.http.HttpUrlConnection;
import org.opennms.protocols.http.SampleData;
import org.opennms.protocols.xml.config.Content;
import org.opennms.protocols.xml.config.Request;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@TestExecutionListeners(value={JUnitHttpServerExecutionListener.class})
public class HttpUrlConnectionTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @JUnitHttpServer(port=10342, https=false, webapps={@Webapp(context="/junit", path="src/test/resources/test-webapp")})
    public void testServlet() throws Exception {
        String xml = "<person><firstName>Alejandro</firstName></person>";
        HttpClientWrapper clientWrapper = HttpClientWrapper.create();
        try {
            StringEntity entity = new StringEntity(xml, ContentType.APPLICATION_XML);
            HttpPost method = new HttpPost("http://localhost:10342/junit/test/sample");
            method.setEntity((HttpEntity)entity);
            CloseableHttpResponse response = clientWrapper.execute((HttpUriRequest)method);
            Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
            Assert.assertEquals((Object)"OK!", (Object)EntityUtils.toString((HttpEntity)response.getEntity()));
        }
        finally {
            IOUtils.closeQuietly((Closeable)clientWrapper);
        }
    }

    @Test
    @JUnitHttpServer(port=10342, https=false, webapps={@Webapp(context="/junit", path="src/test/resources/test-webapp")})
    public void testXml() throws Exception {
        String xml = "<person><firstName>Alejandro</firstName><lastName>Galue</lastName></person>";
        Request req = this.buildRequest("application/xml", xml);
        this.executeRequest(req);
    }

    @Test
    @JUnitHttpServer(port=10342, https=false, webapps={@Webapp(context="/junit", path="src/test/resources/test-webapp")})
    public void testJson() throws Exception {
        String json = "{ person: { firstName: 'Alejandro', lastName: 'Galue' } }";
        Request req = this.buildRequest("application/json", json);
        this.executeRequest(req);
    }

    @Test
    @JUnitHttpServer(port=10342, https=false, webapps={@Webapp(context="/junit", path="src/test/resources/test-webapp")})
    public void testForm() throws Exception {
        String json = "<form-fields><form-field name='firstName'>Alejandro</form-field><form-field name='lastName'>Galue</form-field></form-fields>";
        Request req = this.buildRequest("application/x-www-form-urlencoded", json);
        this.executeRequest(req);
    }

    private Request buildRequest(String contentType, String contentData) {
        Request req = new Request();
        req.setMethod("POST");
        req.addParameter("timeout", "3000");
        req.addParameter("retries", "2");
        req.addHeader("User-Agent", "FireFox 22.0");
        req.setContent(new Content(contentType, contentData));
        return req;
    }

    private void executeRequest(Request request) throws Exception {
        URL url = new URL("http://localhost:10342/junit/test/post");
        HttpUrlConnection connection = new HttpUrlConnection(url, request);
        connection.connect();
        String output = IOUtils.toString((InputStream)connection.getInputStream());
        SampleData data = (SampleData)JaxbUtils.unmarshal(SampleData.class, (String)output);
        Assert.assertNotNull((Object)data);
        Assert.assertEquals((long)2L, (long)data.getParameters().size());
        Assert.assertEquals((Object)"Alejandro", (Object)data.getParameter("firstName"));
        Assert.assertEquals((Object)"Galue", (Object)data.getParameter("lastName"));
    }
}

