/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.xml.collector;

import java.io.File;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionResource;
import org.opennms.netmgt.collection.api.ServiceParameters;
import org.opennms.netmgt.rrd.RrdRepository;
import org.opennms.protocols.xml.collector.XmlCollectionResource;
import org.opennms.protocols.xml.collector.XmlResourceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlMultiInstanceCollectionResource
extends XmlCollectionResource {
    private static final Logger LOG = LoggerFactory.getLogger(XmlMultiInstanceCollectionResource.class);
    private final String m_instance;
    private String m_resourceLabel;
    private final XmlResourceType m_resourceType;

    public XmlMultiInstanceCollectionResource(CollectionAgent agent, String instance, XmlResourceType type) {
        super(agent);
        this.m_resourceType = type;
        this.m_instance = instance;
    }

    public boolean shouldPersist(ServiceParameters params) {
        return this.m_resourceType.getPersistenceSelectorStrategy().shouldPersist((CollectionResource)this);
    }

    public File getResourceDir(RrdRepository repository) {
        String resourcePath = this.m_resourceType.getStorageStrategy().getRelativePathForAttribute(this.getParent(), this.getInterfaceLabel());
        File resourceDir = new File(repository.getRrdBaseDir(), resourcePath);
        LOG.debug("getResourceDir: {}", (Object)resourceDir);
        return resourceDir;
    }

    @Override
    public String getResourceTypeName() {
        return this.m_resourceType.getName();
    }

    @Override
    public String getInstance() {
        return this.m_instance;
    }

    public String toString() {
        return "node[" + this.m_agent.getNodeId() + "]." + this.getResourceTypeName() + "[" + this.getInterfaceLabel() + "]";
    }

    public String getInterfaceLabel() {
        if (this.m_resourceLabel == null) {
            this.m_resourceLabel = this.m_resourceType.getStorageStrategy().getResourceNameFromIndex((CollectionResource)this);
        }
        return this.m_resourceLabel;
    }
}

