/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.xml.collector;

import org.opennms.netmgt.collection.api.CollectionAttributeType;
import org.opennms.netmgt.collection.api.CollectionResource;
import org.opennms.netmgt.collection.support.AbstractCollectionAttribute;
import org.opennms.protocols.xml.collector.XmlCollectionAttributeType;
import org.opennms.protocols.xml.collector.XmlCollectionResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlCollectionAttribute
extends AbstractCollectionAttribute {
    private static final Logger LOG = LoggerFactory.getLogger(XmlCollectionAttribute.class);
    private final String m_value;

    public XmlCollectionAttribute(XmlCollectionResource resource, XmlCollectionAttributeType attribType, String value) {
        super((CollectionAttributeType)attribType, (CollectionResource)resource);
        this.m_value = value;
    }

    public String getNumericValue() {
        try {
            Double d = Double.parseDouble(this.m_value);
            return d.toString();
        }
        catch (Exception e) {
            LOG.debug("getNumericValue: the value {} is not a valid number. Removing invalid characters and try again.", (Object)this.m_value);
            try {
                Double d = Double.parseDouble(this.m_value.replaceAll("[^-\\d.]+", ""));
                return d.toString();
            }
            catch (Exception ex) {
                LOG.warn("getNumericValue: the value {} is not parsable as a valid numeric value.", (Object)this.m_value);
                return "U";
            }
        }
    }

    public String getStringValue() {
        return this.m_value;
    }

    public String toString() {
        return "XmlCollectionAttribute " + this.getName() + "=" + this.getStringValue();
    }

    public String getMetricIdentifier() {
        return "Not supported yet._XML_" + this.getName();
    }
}

