/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.json.collector;

import java.util.Date;
import java.util.Map;
import net.sf.json.JSONObject;
import org.opennms.netmgt.collectd.CollectionAgent;
import org.opennms.netmgt.collectd.CollectionException;
import org.opennms.netmgt.config.collector.AttributeGroupType;
import org.opennms.protocols.json.collector.AbstractJsonCollectionHandler;
import org.opennms.protocols.xml.collector.XmlCollectionResource;
import org.opennms.protocols.xml.collector.XmlCollectionSet;
import org.opennms.protocols.xml.config.Request;
import org.opennms.protocols.xml.config.XmlDataCollection;
import org.opennms.protocols.xml.config.XmlSource;

public class DefaultJsonCollectionHandler
extends AbstractJsonCollectionHandler {
    @Override
    public XmlCollectionSet collect(CollectionAgent agent, XmlDataCollection collection, Map<String, Object> parameters) throws CollectionException {
        XmlCollectionSet collectionSet = new XmlCollectionSet(agent);
        collectionSet.setCollectionTimestamp(new Date());
        collectionSet.setStatus(0);
        try {
            for (XmlSource source : collection.getXmlSources()) {
                String urlStr = this.parseUrl(source.getUrl(), agent, collection.getXmlRrd().getStep());
                Request request = this.parseRequest(source.getRequest(), agent);
                JSONObject json = this.getJSONObject(urlStr, request);
                this.fillCollectionSet(agent, collectionSet, source, json);
            }
            collectionSet.setStatus(1);
            return collectionSet;
        }
        catch (Exception e) {
            collectionSet.setStatus(2);
            throw new CollectionException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected void processXmlResource(XmlCollectionResource collectionResource, AttributeGroupType attribGroupType) {
    }
}

