/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.http.collector;

import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.select.Elements;
import org.opennms.netmgt.collectd.CollectionAgent;
import org.opennms.netmgt.collectd.CollectionException;
import org.opennms.netmgt.config.collector.AttributeGroupType;
import org.opennms.protocols.xml.collector.AbstractXmlCollectionHandler;
import org.opennms.protocols.xml.collector.UrlFactory;
import org.opennms.protocols.xml.collector.XmlCollectionAttributeType;
import org.opennms.protocols.xml.collector.XmlCollectionResource;
import org.opennms.protocols.xml.collector.XmlCollectionSet;
import org.opennms.protocols.xml.collector.XmlCollectorException;
import org.opennms.protocols.xml.config.Request;
import org.opennms.protocols.xml.config.XmlDataCollection;
import org.opennms.protocols.xml.config.XmlGroup;
import org.opennms.protocols.xml.config.XmlObject;
import org.opennms.protocols.xml.config.XmlSource;

public class HttpCollectionHandler
extends AbstractXmlCollectionHandler {
    @Override
    public XmlCollectionSet collect(CollectionAgent agent, XmlDataCollection collection, Map<String, Object> parameters) throws CollectionException {
        XmlCollectionSet collectionSet = new XmlCollectionSet(agent);
        collectionSet.setCollectionTimestamp(new Date());
        collectionSet.setStatus(0);
        try {
            for (XmlSource source : collection.getXmlSources()) {
                String urlStr = this.parseUrl(source.getUrl(), agent, collection.getXmlRrd().getStep());
                Request request = this.parseRequest(source.getRequest(), agent);
                Document doc = this.getJsoupDocument(urlStr, request);
                this.fillCollectionSet(agent, collectionSet, source, doc);
            }
            collectionSet.setStatus(1);
            return collectionSet;
        }
        catch (Exception e) {
            collectionSet.setStatus(2);
            throw new CollectionException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected void processXmlResource(XmlCollectionResource collectionResource, AttributeGroupType attribGroupType) {
    }

    protected void fillCollectionSet(CollectionAgent agent, XmlCollectionSet collectionSet, XmlSource source, Document doc) throws ParseException {
        for (XmlGroup group : source.getXmlGroups()) {
            this.log().debug("fillCollectionSet: getting resources for XML group " + group.getName() + " using selector " + group.getResourceXpath());
            Date timestamp = this.getTimeStamp(doc, group);
            Elements elements = doc.select(group.getResourceXpath());
            this.log().debug("fillCollectionSet: " + group.getResourceXpath() + " => " + elements);
            String resourceName = this.getResourceName(elements, group);
            this.log().debug("fillCollectionSet: processing XML resource " + resourceName);
            XmlCollectionResource collectionResource = this.getCollectionResource(agent, resourceName, group.getResourceType(), timestamp);
            AttributeGroupType attribGroupType = new AttributeGroupType(group.getName(), group.getIfType());
            for (XmlObject object : group.getXmlObjects()) {
                Elements el = elements.select(object.getXpath());
                XmlCollectionAttributeType attribType = new XmlCollectionAttributeType(object, attribGroupType);
                collectionResource.setAttributeValue(attribType, el == null ? null : el.html());
            }
            this.processXmlResource(collectionResource, attribGroupType);
            collectionSet.getCollectionResources().add(collectionResource);
        }
    }

    private String getResourceName(Elements elements, XmlGroup group) {
        if (group.hasMultipleResourceKey()) {
            ArrayList<String> keys = new ArrayList<String>();
            for (String key : group.getXmlResourceKey().getKeyXpathList()) {
                this.log().debug("getResourceName: getting key for resource's name using selector " + key);
                Elements el = elements.select(key);
                if (el == null) continue;
                keys.add(el.html());
            }
            return StringUtils.join(keys, (String)"_");
        }
        if (group.getKeyXpath() == null) {
            return "node";
        }
        this.log().debug("getResourceName: getting key for resource's name using selector " + group.getKeyXpath());
        Elements el = elements.select(group.getKeyXpath());
        return el == null ? null : el.html();
    }

    protected Date getTimeStamp(Document doc, XmlGroup group) {
        if (group.getTimestampXpath() == null) {
            return null;
        }
        String pattern = group.getTimestampFormat() == null ? "yyyy-MM-dd HH:mm:ss" : group.getTimestampFormat();
        this.log().debug("getTimeStamp: retrieving custom timestamp to be used when updating RRDs using selector " + group.getTimestampXpath() + " and pattern " + pattern);
        Elements el = doc.select(group.getTimestampXpath());
        if (el == null) {
            return null;
        }
        String value = el.html();
        Date date = null;
        try {
            DateTimeFormatter dtf = DateTimeFormat.forPattern((String)pattern);
            DateTime dateTime = dtf.parseDateTime(value);
            date = dateTime.toDate();
        }
        catch (Exception e) {
            this.log().warn("getTimeStamp: can't convert custom timetime " + value + " using pattern " + pattern);
        }
        return date;
    }

    protected Document getJsoupDocument(String urlString, Request request) {
        Document document;
        InputStream is = null;
        URLConnection c = null;
        try {
            Document doc;
            URL url = UrlFactory.getUrl(urlString, request);
            c = url.openConnection();
            is = c.getInputStream();
            document = doc = Jsoup.parse((InputStream)is, (String)"UTF-8", (String)"/");
        }
        catch (Exception e) {
            try {
                throw new XmlCollectorException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                UrlFactory.disconnect(c);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
        UrlFactory.disconnect(c);
        return document;
    }
}

