/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.xml.collector;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.opennms.core.utils.LogUtils;
import org.opennms.protocols.http.HttpUrlConnection;
import org.opennms.protocols.http.HttpUrlHandler;
import org.opennms.protocols.http.HttpsUrlHandler;
import org.opennms.protocols.sftp.Sftp3gppUrlHandler;
import org.opennms.protocols.sftp.SftpUrlConnection;
import org.opennms.protocols.sftp.SftpUrlHandler;
import org.opennms.protocols.xml.config.Request;

public class UrlFactory {
    private UrlFactory() {
    }

    public static URL getUrl(String urlStr, Request request) throws MalformedURLException {
        URL url = null;
        String protocol = null;
        try {
            protocol = urlStr.substring(0, urlStr.indexOf("://")).toLowerCase();
        }
        catch (Exception e) {
            return null;
        }
        url = "sftp".equals(protocol) ? new URL(null, urlStr, new SftpUrlHandler()) : ("sftp.3gpp".equals(protocol) ? new URL(null, urlStr, new Sftp3gppUrlHandler()) : ("http".equals(protocol) ? new URL(null, urlStr, new HttpUrlHandler(request)) : ("https".equals(protocol) ? new URL(null, urlStr, new HttpsUrlHandler(request)) : new URL(urlStr))));
        return url;
    }

    public static void disconnect(URLConnection connection) {
        try {
            if (connection == null) {
                return;
            }
            if (connection instanceof SftpUrlConnection) {
                ((SftpUrlConnection)connection).disconnect();
            }
            if (connection instanceof HttpUrlConnection) {
                ((HttpUrlConnection)connection).disconnect();
            }
        }
        catch (Exception e) {
            LogUtils.errorf(UrlFactory.class, (Throwable)e, (String)"Can't close open connection.", (Object[])new Object[0]);
        }
    }
}

