/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.xml.collector;

import java.beans.PropertyDescriptor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.opennms.core.utils.BeanUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.collectd.CollectionAgent;
import org.opennms.netmgt.collectd.PersistAllSelectorStrategy;
import org.opennms.netmgt.config.DataCollectionConfigFactory;
import org.opennms.netmgt.config.collector.AttributeGroupType;
import org.opennms.netmgt.config.datacollection.PersistenceSelectorStrategy;
import org.opennms.netmgt.config.datacollection.ResourceType;
import org.opennms.netmgt.config.datacollection.StorageStrategy;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.RrdRepository;
import org.opennms.protocols.xml.collector.ConstantTimeKeeper;
import org.opennms.protocols.xml.collector.UrlFactory;
import org.opennms.protocols.xml.collector.XmlCollectionAttributeType;
import org.opennms.protocols.xml.collector.XmlCollectionHandler;
import org.opennms.protocols.xml.collector.XmlCollectionResource;
import org.opennms.protocols.xml.collector.XmlCollectionSet;
import org.opennms.protocols.xml.collector.XmlCollectorException;
import org.opennms.protocols.xml.collector.XmlMultiInstanceCollectionResource;
import org.opennms.protocols.xml.collector.XmlResourceType;
import org.opennms.protocols.xml.collector.XmlSingleInstanceCollectionResource;
import org.opennms.protocols.xml.collector.XmlStorageStrategy;
import org.opennms.protocols.xml.config.Content;
import org.opennms.protocols.xml.config.Header;
import org.opennms.protocols.xml.config.Parameter;
import org.opennms.protocols.xml.config.Request;
import org.opennms.protocols.xml.config.XmlGroup;
import org.opennms.protocols.xml.config.XmlObject;
import org.opennms.protocols.xml.config.XmlSource;
import org.springframework.beans.BeanWrapperImpl;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractXmlCollectionHandler
implements XmlCollectionHandler {
    private String m_serviceName;
    private NodeDao m_nodeDao;
    private RrdRepository m_rrdRepository;
    private HashMap<String, XmlResourceType> m_resourceTypeList = new HashMap();

    @Override
    public void setServiceName(String serviceName) {
        this.m_serviceName = serviceName;
    }

    @Override
    public void setRrdRepository(RrdRepository rrdRepository) {
        this.m_rrdRepository = rrdRepository;
    }

    public String getServiceName() {
        return this.m_serviceName;
    }

    public RrdRepository getRrdRepository() {
        return this.m_rrdRepository;
    }

    public NodeDao getNodeDao() {
        if (this.m_nodeDao == null) {
            this.m_nodeDao = (NodeDao)BeanUtils.getBean((String)"daoContext", (String)"nodeDao", NodeDao.class);
        }
        return this.m_nodeDao;
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.m_nodeDao = nodeDao;
    }

    protected void fillCollectionSet(CollectionAgent agent, XmlCollectionSet collectionSet, XmlSource source, org.w3c.dom.Document doc) throws XPathExpressionException, ParseException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        for (XmlGroup group : source.getXmlGroups()) {
            this.log().debug("fillCollectionSet: getting resources for XML group " + group.getName() + " using XPATH " + group.getResourceXpath());
            Date timestamp = this.getTimeStamp(doc, xpath, group);
            NodeList resourceList = (NodeList)xpath.evaluate(group.getResourceXpath(), doc, XPathConstants.NODESET);
            for (int j = 0; j < resourceList.getLength(); ++j) {
                Node resource = resourceList.item(j);
                String resourceName = this.getResourceName(xpath, group, resource);
                this.log().debug("fillCollectionSet: processing XML resource " + resourceName);
                XmlCollectionResource collectionResource = this.getCollectionResource(agent, resourceName, group.getResourceType(), timestamp);
                AttributeGroupType attribGroupType = new AttributeGroupType(group.getName(), group.getIfType());
                for (XmlObject object : group.getXmlObjects()) {
                    String value = (String)xpath.evaluate(object.getXpath(), resource, XPathConstants.STRING);
                    XmlCollectionAttributeType attribType = new XmlCollectionAttributeType(object, attribGroupType);
                    collectionResource.setAttributeValue(attribType, value);
                }
                this.processXmlResource(collectionResource, attribGroupType);
                collectionSet.getCollectionResources().add(collectionResource);
            }
        }
    }

    private String getResourceName(XPath xpath, XmlGroup group, Node resource) throws XPathExpressionException {
        if (group.hasMultipleResourceKey()) {
            ArrayList<String> keys = new ArrayList<String>();
            for (String key : group.getXmlResourceKey().getKeyXpathList()) {
                this.log().debug("getResourceName: getting key for resource's name using " + key);
                Node keyNode = (Node)xpath.evaluate(key, resource, XPathConstants.NODE);
                keys.add(keyNode.getNodeValue() == null ? keyNode.getTextContent() : keyNode.getNodeValue());
            }
            return StringUtils.join(keys, (String)"_");
        }
        if (group.getKeyXpath() == null) {
            return "node";
        }
        this.log().debug("getResourceName: getting key for resource's name using " + group.getKeyXpath());
        Node keyNode = (Node)xpath.evaluate(group.getKeyXpath(), resource, XPathConstants.NODE);
        return keyNode.getNodeValue() == null ? keyNode.getTextContent() : keyNode.getNodeValue();
    }

    protected abstract void processXmlResource(XmlCollectionResource var1, AttributeGroupType var2);

    protected XmlCollectionResource getCollectionResource(CollectionAgent agent, String instance, String resourceType, Date timestamp) {
        XmlCollectionResource resource = null;
        if (resourceType.toLowerCase().equals("node")) {
            resource = new XmlSingleInstanceCollectionResource(agent);
        } else {
            XmlResourceType type = this.getXmlResourceType(agent, resourceType);
            resource = new XmlMultiInstanceCollectionResource(agent, instance, type);
        }
        if (timestamp != null) {
            this.log().debug("getCollectionResource: the date that will be used when updating the RRDs is " + timestamp);
            resource.setTimeKeeper(new ConstantTimeKeeper(timestamp));
        }
        return resource;
    }

    protected Date getTimeStamp(org.w3c.dom.Document doc, XPath xpath, XmlGroup group) throws XPathExpressionException {
        if (group.getTimestampXpath() == null) {
            return null;
        }
        String pattern = group.getTimestampFormat() == null ? "yyyy-MM-dd HH:mm:ss" : group.getTimestampFormat();
        this.log().debug("getTimeStamp: retrieving custom timestamp to be used when updating RRDs using XPATH " + group.getTimestampXpath() + " and pattern " + pattern);
        Node tsNode = (Node)xpath.evaluate(group.getTimestampXpath(), doc, XPathConstants.NODE);
        if (tsNode == null) {
            this.log().warn("getTimeStamp: can't find the custom timestamp using XPATH " + group.getTimestampXpath());
            return null;
        }
        Date date = null;
        String value = tsNode.getNodeValue() == null ? tsNode.getTextContent() : tsNode.getNodeValue();
        try {
            DateTimeFormatter dtf = DateTimeFormat.forPattern((String)pattern);
            DateTime dateTime = dtf.parseDateTime(value);
            date = dateTime.toDate();
        }
        catch (Exception e) {
            this.log().warn("getTimeStamp: can't convert custom timetime " + value + " using pattern " + pattern);
        }
        return date;
    }

    protected String parseUrl(String unformattedUrl, CollectionAgent agent, Integer collectionStep) throws IllegalArgumentException {
        OnmsNode node = (OnmsNode)this.getNodeDao().get((Serializable)Integer.valueOf(agent.getNodeId()));
        String url = this.parseString("URL", unformattedUrl, node, agent.getHostAddress());
        return url.replaceAll("[{]step[}]", collectionStep.toString());
    }

    protected Request parseRequest(Request unformattedRequest, CollectionAgent agent) throws IllegalArgumentException {
        if (unformattedRequest == null) {
            return null;
        }
        OnmsNode node = (OnmsNode)this.getNodeDao().get((Serializable)Integer.valueOf(agent.getNodeId()));
        Request request = new Request();
        for (Header header : unformattedRequest.getHeaders()) {
            request.addHeader(header.getName(), this.parseString(header.getName(), header.getValue(), node, agent.getHostAddress()));
        }
        for (Parameter param : unformattedRequest.getParameters()) {
            request.addParameter(param.getName(), this.parseString(param.getName(), param.getValue(), node, agent.getHostAddress()));
        }
        Content cnt = unformattedRequest.getContent();
        if (cnt != null) {
            request.setContent(new Content(cnt.getType(), this.parseString("Content", cnt.getData(), node, agent.getHostAddress())));
        }
        return request;
    }

    protected String parseString(String reference, String unformattedString, OnmsNode node, String ipAddress) throws IllegalArgumentException {
        if (unformattedString == null) {
            return null;
        }
        String formattedString = unformattedString.replaceAll("[{](?i)(ipAddr|ipAddress)[}]", ipAddress);
        formattedString = formattedString.replaceAll("[{](?i)nodeId[}]", node.getNodeId());
        if (node.getLabel() != null) {
            formattedString = formattedString.replaceAll("[{](?i)nodeLabel[}]", node.getLabel());
        }
        if (node.getForeignId() != null) {
            formattedString = formattedString.replaceAll("[{](?i)foreignId[}]", node.getForeignId());
        }
        if (node.getForeignSource() != null) {
            formattedString = formattedString.replaceAll("[{](?i)foreignSource[}]", node.getForeignSource());
        }
        if (node.getAssetRecord() != null) {
            BeanWrapperImpl wrapper = new BeanWrapperImpl((Object)node.getAssetRecord());
            for (PropertyDescriptor p : wrapper.getPropertyDescriptors()) {
                Object obj = wrapper.getPropertyValue(p.getName());
                if (obj == null) continue;
                formattedString = formattedString.replaceAll("[{](?i)" + p.getName() + "[}]", obj.toString());
            }
        }
        if (formattedString.matches(".*[{].+[}].*")) {
            throw new IllegalArgumentException("The " + reference + " " + formattedString + " contains unknown placeholders.");
        }
        return formattedString;
    }

    protected org.w3c.dom.Document getXmlDocument(String urlString, Request request) {
        org.w3c.dom.Document document;
        InputStream is = null;
        try {
            URL url = UrlFactory.getUrl(urlString, request);
            URLConnection c = url.openConnection();
            is = c.getInputStream();
            is = this.preProcessHtml(request, is);
            is = this.applyXsltTransformation(request, is);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setIgnoringComments(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            org.w3c.dom.Document doc = builder.parse(is);
            UrlFactory.disconnect(c);
            document = doc;
        }
        catch (Exception e) {
            try {
                throw new XmlCollectorException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
        return document;
    }

    private InputStream applyXsltTransformation(Request request, InputStream is) throws Exception {
        if (request == null) {
            return is;
        }
        String xsltFilename = request.getParameter("xslt-source-file");
        if (xsltFilename == null) {
            return is;
        }
        File xsltFile = new File(xsltFilename);
        if (!xsltFile.exists()) {
            return is;
        }
        TransformerFactory factory = TransformerFactory.newInstance();
        StreamSource xslt = new StreamSource(xsltFile);
        Transformer transformer = factory.newTransformer(xslt);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        transformer.transform(new StreamSource(is), new StreamResult(baos));
        IOUtils.closeQuietly((InputStream)is);
        return new ByteArrayInputStream(baos.toByteArray());
    }

    private InputStream preProcessHtml(Request request, InputStream is) throws IOException {
        if (request == null) {
            return is;
        }
        if (Boolean.parseBoolean(request.getParameter("pre-parse-html"))) {
            Document doc = Jsoup.parse((InputStream)is, (String)"UTF-8", (String)"/");
            IOUtils.closeQuietly((InputStream)is);
            return new ByteArrayInputStream(doc.outerHtml().getBytes());
        }
        return is;
    }

    protected XmlResourceType getXmlResourceType(CollectionAgent agent, String resourceType) {
        if (!this.m_resourceTypeList.containsKey(resourceType)) {
            ResourceType rt = (ResourceType)DataCollectionConfigFactory.getInstance().getConfiguredResourceTypes().get(resourceType);
            if (rt == null) {
                this.log().debug("getXmlResourceType: using default XML resource type strategy.");
                rt = new ResourceType();
                rt.setName(resourceType);
                rt.setStorageStrategy(new StorageStrategy());
                rt.getStorageStrategy().setClazz(XmlStorageStrategy.class.getName());
                rt.setPersistenceSelectorStrategy(new PersistenceSelectorStrategy());
                rt.getPersistenceSelectorStrategy().setClazz(PersistAllSelectorStrategy.class.getName());
            }
            XmlResourceType type = new XmlResourceType(agent, rt);
            this.m_resourceTypeList.put(resourceType, type);
        }
        return this.m_resourceTypeList.get(resourceType);
    }

    protected ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }
}

