/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.xml.collector;

import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.collectd.AbstractCollectionAttribute;
import org.opennms.netmgt.config.collector.CollectionAttribute;
import org.opennms.netmgt.config.collector.CollectionAttributeType;
import org.opennms.netmgt.config.collector.CollectionResource;
import org.opennms.netmgt.config.collector.ServiceParameters;
import org.opennms.protocols.xml.collector.XmlCollectionAttributeType;
import org.opennms.protocols.xml.collector.XmlCollectionResource;

public class XmlCollectionAttribute
extends AbstractCollectionAttribute
implements CollectionAttribute {
    private String m_value;
    private XmlCollectionResource m_resource;
    private XmlCollectionAttributeType m_attribType;

    public XmlCollectionAttribute(XmlCollectionResource resource, XmlCollectionAttributeType attribType, String value) {
        this.m_resource = resource;
        this.m_attribType = attribType;
        this.m_value = value;
    }

    public CollectionAttributeType getAttributeType() {
        return this.m_attribType;
    }

    public String getName() {
        return this.m_attribType.getName();
    }

    public String getNumericValue() {
        try {
            Double d = Double.parseDouble(this.m_value);
            return d.toString();
        }
        catch (Exception e) {
            this.log().debug("getNumericValue: the value " + this.m_value + " is not a valid number. Removing invalid characters and try again.");
            try {
                Double d = Double.parseDouble(this.m_value.replaceAll("[^-\\d.]+", ""));
                return d.toString();
            }
            catch (Exception ex) {
                this.log().warn("getNumericValue: the value " + this.m_value + " is not parsable as a valid numeric value.");
                return "U";
            }
        }
    }

    public CollectionResource getResource() {
        return this.m_resource;
    }

    public String getStringValue() {
        return this.m_value;
    }

    public boolean shouldPersist(ServiceParameters params) {
        return true;
    }

    public String getType() {
        return this.m_attribType.getType();
    }

    public String toString() {
        return "XmlCollectionAttribute " + this.getName() + "=" + this.getStringValue();
    }

    protected ThreadCategory log() {
        return ThreadCategory.getInstance(((Object)((Object)this)).getClass());
    }
}

