/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.xml.collector;

import java.util.Date;
import java.util.Map;
import org.opennms.netmgt.collectd.CollectionAgent;
import org.opennms.netmgt.collectd.CollectionException;
import org.opennms.netmgt.config.collector.AttributeGroupType;
import org.opennms.protocols.xml.collector.AbstractXmlCollectionHandler;
import org.opennms.protocols.xml.collector.XmlCollectionResource;
import org.opennms.protocols.xml.collector.XmlCollectionSet;
import org.opennms.protocols.xml.config.XmlDataCollection;
import org.opennms.protocols.xml.config.XmlSource;
import org.w3c.dom.Document;

public class DefaultXmlCollectionHandler
extends AbstractXmlCollectionHandler {
    @Override
    public XmlCollectionSet collect(CollectionAgent agent, XmlDataCollection collection, Map<String, Object> parameters) throws CollectionException {
        XmlCollectionSet collectionSet = new XmlCollectionSet(agent);
        collectionSet.setCollectionTimestamp(new Date());
        collectionSet.setStatus(0);
        try {
            for (XmlSource source : collection.getXmlSources()) {
                String urlStr = this.parseUrl(source.getUrl(), agent, collection.getXmlRrd().getStep());
                Document doc = this.getXmlDocument(urlStr);
                this.fillCollectionSet(agent, collectionSet, source, doc);
            }
            collectionSet.setStatus(1);
            return collectionSet;
        }
        catch (Exception e) {
            collectionSet.setStatus(2);
            throw new CollectionException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected void processXmlResource(XmlCollectionResource collectionResource, AttributeGroupType attribGroupType) {
    }
}

