/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.http;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.opennms.core.utils.ThreadCategory;

public class HttpUrlConnection
extends URLConnection {
    private URL m_url;

    protected HttpUrlConnection(URL url) {
        super(url);
        this.m_url = url;
    }

    @Override
    public void connect() throws IOException {
    }

    @Override
    public InputStream getInputStream() throws IOException {
        try {
            int port = this.m_url.getPort() > 0 ? this.m_url.getPort() : this.m_url.getDefaultPort();
            String[] userInfo = this.m_url.getUserInfo() == null ? null : this.m_url.getUserInfo().split(":");
            DefaultHttpClient client = new DefaultHttpClient();
            HttpGet request = new HttpGet(URIUtils.createURI((String)this.m_url.getProtocol(), (String)this.m_url.getHost(), (int)port, (String)this.m_url.getPath(), (String)this.m_url.getQuery(), null));
            if (userInfo != null) {
                UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(userInfo[0], userInfo[1]);
                request.addHeader(BasicScheme.authenticate((Credentials)credentials, (String)"UTF-8", (boolean)false));
            }
            HttpResponse response = client.execute((HttpUriRequest)request);
            return new ByteArrayInputStream(EntityUtils.toByteArray((HttpEntity)response.getEntity()));
        }
        catch (Exception e) {
            throw new IOException("Can't retrieve " + this.m_url.getPath() + " from " + this.m_url.getHost() + " because " + e.getMessage());
        }
    }

    protected ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }
}

