/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.xml.collector;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.io.IOUtils;
import org.opennms.netmgt.collectd.CollectionAgent;
import org.opennms.netmgt.collectd.CollectionException;
import org.opennms.netmgt.config.collector.AttributeGroupType;
import org.opennms.netmgt.dao.support.ResourceTypeUtils;
import org.opennms.protocols.sftp.Sftp3gppUrlConnection;
import org.opennms.protocols.xml.collector.AbstractXmlCollectionHandler;
import org.opennms.protocols.xml.collector.UrlFactory;
import org.opennms.protocols.xml.collector.XmlCollectionAttributeType;
import org.opennms.protocols.xml.collector.XmlCollectionResource;
import org.opennms.protocols.xml.collector.XmlCollectionSet;
import org.opennms.protocols.xml.config.XmlDataCollection;
import org.opennms.protocols.xml.config.XmlObject;
import org.opennms.protocols.xml.config.XmlSource;
import org.w3c.dom.Document;

public class Sftp3gppXmlCollectionHandler
extends AbstractXmlCollectionHandler {
    public static final String XML_LAST_FILENAME = "_xmlCollectorLastFilename";
    private Properties m_pmGroups;

    @Override
    public XmlCollectionSet collect(CollectionAgent agent, XmlDataCollection collection, Map<String, Object> parameters) throws CollectionException {
        XmlCollectionSet collectionSet = new XmlCollectionSet(agent);
        collectionSet.setCollectionTimestamp(new Date());
        collectionSet.setStatus(0);
        try {
            File resourceDir = new File(this.getRrdRepository().getRrdBaseDir(), Integer.toString(agent.getNodeId()));
            for (XmlSource source : collection.getXmlSources()) {
                if (!source.getUrl().startsWith("sftp.3gpp")) {
                    throw new CollectionException("The 3GPP SFTP Collection Handler can only use the protocol sftp.3gpp");
                }
                String urlStr = this.parseUrl(source.getUrl(), agent, collection.getXmlRrd().getStep());
                URL url = UrlFactory.getUrl(urlStr);
                String lastFile = this.getLastFilename(resourceDir, url.getPath());
                Sftp3gppUrlConnection connection = (Sftp3gppUrlConnection)url.openConnection();
                if (lastFile == null) {
                    lastFile = connection.get3gppFileName();
                    this.log().debug("collect(single): retrieving file from " + url.getPath() + File.separatorChar + lastFile + " from " + agent.getHostAddress());
                    Document doc = this.getXmlDocument(urlStr);
                    this.fillCollectionSet(agent, collectionSet, source, doc);
                    this.setLastFilename(resourceDir, url.getPath(), lastFile);
                    this.deleteFile(connection, lastFile);
                    continue;
                }
                connection.connect();
                List<String> files = connection.getFileList();
                long lastTs = connection.getTimeStampFromFile(lastFile);
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                factory.setIgnoringComments(true);
                boolean collected = false;
                for (String fileName : files) {
                    if (connection.getTimeStampFromFile(fileName) <= lastTs) continue;
                    this.log().debug("collect(multiple): retrieving file " + fileName + " from " + agent.getHostAddress());
                    InputStream is = connection.getFile(fileName);
                    Document doc = builder.parse(is);
                    IOUtils.closeQuietly((InputStream)is);
                    this.fillCollectionSet(agent, collectionSet, source, doc);
                    this.setLastFilename(resourceDir, url.getPath(), fileName);
                    this.deleteFile(connection, fileName);
                    collected = true;
                }
                if (!collected) {
                    this.log().warn("collect: could not find any file after " + lastFile + " on " + agent);
                }
                connection.disconnect();
            }
            collectionSet.setStatus(1);
            return collectionSet;
        }
        catch (Exception e) {
            collectionSet.setStatus(2);
            throw new CollectionException(e.getMessage(), (Throwable)e);
        }
    }

    private String getLastFilename(File resourceDir, String targetPath) throws Exception {
        String filename = null;
        try {
            filename = ResourceTypeUtils.getStringProperty((File)resourceDir, (String)this.getCacheId(targetPath));
        }
        catch (Exception e) {
            this.log().info("getLastFilename: creating a new filename tracker on " + resourceDir);
        }
        return filename;
    }

    private void setLastFilename(File resourceDir, String targetPath, String filename) throws Exception {
        ResourceTypeUtils.updateStringProperty((File)resourceDir, (String)filename, (String)this.getCacheId(targetPath));
    }

    private String getCacheId(String targetPath) {
        return "_xmlCollectorLastFilename." + this.getServiceName() + targetPath.replaceAll("/", "_");
    }

    private void deleteFile(Sftp3gppUrlConnection connection, String fileName) {
        try {
            connection.deleteFile(fileName);
        }
        catch (Exception e) {
            this.log().warn("Can't delete file " + fileName + " from " + connection.getURL().getHost() + " because " + e.getMessage());
        }
    }

    @Override
    protected void processXmlResource(XmlCollectionResource resource, AttributeGroupType attribGroupType) {
        Map<String, String> properties = this.get3gppProperties(this.get3gppFormat(resource.getResourceTypeName()), resource.getInstance());
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            XmlCollectionAttributeType attribType = new XmlCollectionAttributeType(new XmlObject(entry.getKey(), "string"), attribGroupType);
            resource.setAttributeValue(attribType, entry.getValue());
        }
    }

    protected String parseUrl(String unformattedUrl, CollectionAgent agent, Integer collectionStep, long currentTimestamp) throws IllegalArgumentException {
        if (!unformattedUrl.startsWith("sftp.3gpp")) {
            throw new IllegalArgumentException("The 3GPP SFTP Collection Handler can only use the protocol sftp.3gpp");
        }
        String baseUrl = this.parseUrl(unformattedUrl, agent, collectionStep);
        return baseUrl + "&referenceTimestamp=" + currentTimestamp;
    }

    public String get3gppFormat(String resourceType) {
        if (this.m_pmGroups == null) {
            this.m_pmGroups = new Properties();
            try {
                this.m_pmGroups.load(this.getClass().getResourceAsStream("/3gpp-pmgroups.properties"));
            }
            catch (IOException e) {
                this.log().warn("Can't load 3GPP PM Groups formats because " + e.getMessage());
            }
        }
        return this.m_pmGroups.getProperty(resourceType);
    }

    public Map<String, String> get3gppProperties(String format, String measInfoId) {
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        if (format != null) {
            String[] groups;
            for (String group : groups = format.split("\\|")) {
                String[] subgroups;
                for (String subgroup : subgroups = group.split("/")) {
                    String[] pair = subgroup.split("=");
                    if (pair.length <= 1 || !pair[1].matches("^[<].+[>]$")) continue;
                    String valueRegex = pair[1].equals("<directory path>") ? "=([^|]+)" : "=([^|/]+)";
                    Matcher m = Pattern.compile(pair[0] + valueRegex).matcher(measInfoId);
                    if (!m.find()) continue;
                    String v = pair[1].equals("<directory path>") ? m.group(1).replaceAll("\\\\/", "/") : m.group(1);
                    properties.put(pair[0], v);
                }
            }
        }
        properties.put("label", ((Object)properties).toString().replaceAll("[{}]", ""));
        properties.put("instance", measInfoId);
        return properties;
    }
}

