/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.http;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.entity.GzipDecompressingEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.protocol.HttpContext;
import org.opennms.core.utils.ThreadCategory;

public class HttpUrlConnection
extends URLConnection {
    private URL m_url;
    private DefaultHttpClient m_client;

    protected HttpUrlConnection(URL url) {
        super(url);
        this.m_url = url;
    }

    @Override
    public void connect() throws IOException {
        if (this.m_client != null) {
            return;
        }
        this.m_client = new DefaultHttpClient();
        this.m_client.addRequestInterceptor(new HttpRequestInterceptor(){

            public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
                if (!request.containsHeader("Accept-Encoding")) {
                    request.addHeader("Accept-Encoding", "gzip");
                }
            }
        });
        this.m_client.addResponseInterceptor(new HttpResponseInterceptor(){

            public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
                Header ceheader;
                HttpEntity entity = response.getEntity();
                if (entity != null && (ceheader = entity.getContentEncoding()) != null) {
                    HeaderElement[] codecs = ceheader.getElements();
                    for (int i = 0; i < codecs.length; ++i) {
                        if (!codecs[i].getName().equalsIgnoreCase("gzip")) continue;
                        response.setEntity((HttpEntity)new GzipDecompressingEntity(response.getEntity()));
                        return;
                    }
                }
            }
        });
    }

    @Override
    public InputStream getInputStream() throws IOException {
        try {
            if (this.m_client == null) {
                this.connect();
            }
            int port = this.m_url.getPort() > 0 ? this.m_url.getPort() : this.m_url.getDefaultPort();
            String[] userInfo = this.m_url.getUserInfo() == null ? null : this.m_url.getUserInfo().split(":");
            HttpGet request = new HttpGet(URIUtils.createURI((String)this.m_url.getProtocol(), (String)this.m_url.getHost(), (int)port, (String)this.m_url.getPath(), (String)this.m_url.getQuery(), null));
            if (userInfo != null) {
                UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(userInfo[0], userInfo[1]);
                request.addHeader(BasicScheme.authenticate((Credentials)credentials, (String)"UTF-8", (boolean)false));
            }
            HttpResponse response = this.m_client.execute((HttpUriRequest)request);
            return response.getEntity().getContent();
        }
        catch (Exception e) {
            throw new IOException("Can't retrieve " + this.m_url.getPath() + " from " + this.m_url.getHost() + " because " + e.getMessage(), e);
        }
    }

    public void disconnect() {
        if (this.m_client != null) {
            this.m_client.getConnectionManager().shutdown();
        }
    }

    protected ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }
}

