/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.radius.monitor;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.Map;
import net.jradius.client.RadiusClient;
import net.jradius.client.auth.CHAPAuthenticator;
import net.jradius.client.auth.EAPMD5Authenticator;
import net.jradius.client.auth.EAPMSCHAPv2Authenticator;
import net.jradius.client.auth.EAPTTLSAuthenticator;
import net.jradius.client.auth.MSCHAPv1Authenticator;
import net.jradius.client.auth.MSCHAPv2Authenticator;
import net.jradius.client.auth.PAPAuthenticator;
import net.jradius.client.auth.RadiusAuthenticator;
import net.jradius.dictionary.Attr_NASIdentifier;
import net.jradius.dictionary.Attr_Password;
import net.jradius.dictionary.Attr_UserName;
import net.jradius.dictionary.Attr_UserPassword;
import net.jradius.packet.AccessAccept;
import net.jradius.packet.AccessRequest;
import net.jradius.packet.RadiusResponse;
import net.jradius.packet.attribute.AttributeFactory;
import net.jradius.packet.attribute.AttributeList;
import net.jradius.packet.attribute.RadiusAttribute;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.TimeoutTracker;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.monitors.support.ParameterSubstitutingMonitor;
import org.opennms.protocols.radius.utils.RadiusUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Distributable
public final class RadiusAuthMonitor
extends ParameterSubstitutingMonitor {
    private static final Logger LOG = LoggerFactory.getLogger(RadiusAuthMonitor.class);
    public static final int DEFAULT_TIMEOUT = 5000;
    public static final int DEFAULT_RETRY = 0;
    public static final int DEFAULT_AUTH_PORT = 1812;
    public static final int DEFAULT_ACCT_PORT = 1813;
    public static final String DEFAULT_AUTH_TYPE = "pap";
    public static final String DEFAULT_USER = "OpenNMS";
    public static final String DEFAULT_PASSWORD = "OpenNMS";
    public static final String DEFAULT_SECRET = "secret";
    public static final String DEFAULT_NASID = "opennms";
    public static final String DEFAULT_INNER_USER = "Inner-OpenNMS";
    public static final String DEFAULT_TTLS_INNER_AUTH_TYPE = "pap";

    public RadiusAuthMonitor() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        LOG.info("RadiusAuthMonitor class loaded");
    }

    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        PollStatus status = PollStatus.unavailable();
        if (parameters == null) {
            throw new NullPointerException();
        }
        TimeoutTracker tracker = new TimeoutTracker(parameters, 0, 5000);
        int authport = ParameterMap.getKeyedInteger(parameters, (String)"authport", (int)1812);
        int acctport = ParameterMap.getKeyedInteger(parameters, (String)"acctport", (int)1813);
        String user = RadiusAuthMonitor.resolveKeyedString(parameters, (String)"user", (String)"OpenNMS");
        String password = RadiusAuthMonitor.resolveKeyedString(parameters, (String)"password", (String)"OpenNMS");
        String secret = RadiusAuthMonitor.resolveKeyedString(parameters, (String)DEFAULT_SECRET, (String)DEFAULT_SECRET);
        String authType = ParameterMap.getKeyedString(parameters, (String)"authtype", (String)"pap");
        String nasid = RadiusAuthMonitor.resolveKeyedString(parameters, (String)"nasid", (String)DEFAULT_NASID);
        String innerProtocol = ParameterMap.getKeyedString(parameters, (String)"inner-protocol", (String)"pap");
        String innerUser = RadiusAuthMonitor.resolveKeyedString(parameters, (String)"inner-user", (String)DEFAULT_INNER_USER);
        String certFile = ParameterMap.getKeyedString(parameters, (String)"certificate", null);
        InetAddress addr = svc.getAddress();
        AttributeFactory.loadAttributeDictionary((String)"net.jradius.dictionary.AttributeDictionaryImpl");
        int timeout = this.convertTimeoutToSeconds(ParameterMap.getKeyedInteger(parameters, (String)"timeout", (int)5000));
        try {
            RadiusClient rc = new RadiusClient(addr, secret, authport, acctport, timeout);
            tracker.reset();
            while (tracker.shouldRetry()) {
                String reason;
                String reason2;
                CHAPAuthenticator auth;
                AttributeList attributes = new AttributeList();
                attributes.add((RadiusAttribute)new Attr_UserName((Serializable)((Object)user)));
                attributes.add((RadiusAttribute)new Attr_NASIdentifier((Serializable)((Object)nasid)));
                attributes.add((RadiusAttribute)new Attr_UserPassword((Serializable)((Object)password)));
                AccessRequest accessRequest = new AccessRequest(rc, attributes);
                if (authType.equalsIgnoreCase("chap")) {
                    auth = new CHAPAuthenticator();
                } else if (authType.equalsIgnoreCase("pap")) {
                    auth = new PAPAuthenticator();
                } else if (authType.equalsIgnoreCase("mschapv1")) {
                    auth = new MSCHAPv1Authenticator();
                } else if (authType.equalsIgnoreCase("mschapv2")) {
                    auth = new MSCHAPv2Authenticator();
                } else if (authType.equalsIgnoreCase("eapmd5") || authType.equalsIgnoreCase("eap-md5")) {
                    auth = new EAPMD5Authenticator();
                } else if (authType.equalsIgnoreCase("eapmschapv2") || authType.equalsIgnoreCase("eap-mschapv2")) {
                    auth = new EAPMSCHAPv2Authenticator();
                } else if (RadiusUtils.isTunneling(authType)) {
                    if (innerUser == null) {
                        reason2 = "TLS AAA type requested but no inner user defined. Authtype: '" + authType + "'";
                        LOG.debug(reason2);
                        return PollStatus.unavailable((String)reason2);
                    }
                    EAPTTLSAuthenticator tlsAuth = null;
                    if (RadiusUtils.isEAPTTLS(authType)) {
                        EAPTTLSAuthenticator ttlsAuth = tlsAuth = new EAPTTLSAuthenticator();
                        if (innerProtocol != "pap") {
                            String reason3 = "RadiusMonitor can only use 'pap' as inner auth protocol, not " + innerProtocol;
                            LOG.debug(reason3);
                            return PollStatus.unavailable((String)reason3);
                        }
                        ttlsAuth.setInnerProtocol(innerProtocol);
                        AttributeList attrs = new AttributeList();
                        attrs.add((RadiusAttribute)new Attr_UserName((Serializable)((Object)innerUser)));
                        attrs.add((RadiusAttribute)new Attr_Password((Serializable)((Object)password)));
                        ttlsAuth.setTunneledAttributes(attrs);
                    } else if (authType.equalsIgnoreCase("peap")) {
                        reason = "Support for eap peap is not ready yet";
                        LOG.debug(reason);
                        return PollStatus.unavailable((String)reason);
                    }
                    LOG.warn("Server certificate will be trusted");
                    if (certFile == null) {
                        tlsAuth.setTrustAll(Boolean.valueOf(true));
                    }
                    auth = tlsAuth;
                } else {
                    reason2 = "Unknown authenticator type '" + authType + "'";
                    LOG.debug(reason2);
                    return PollStatus.unavailable((String)reason2);
                }
                tracker.startAttempt();
                RadiusResponse reply = rc.authenticate(accessRequest, (RadiusAuthenticator)auth, ParameterMap.getKeyedInteger(parameters, (String)"retry", (int)0));
                if (reply instanceof AccessAccept) {
                    double responseTime = tracker.elapsedTimeInMillis();
                    status = PollStatus.available((Double)responseTime);
                    LOG.debug("Radius service is AVAILABLE on: {}", (Object)addr.getCanonicalHostName());
                    LOG.debug("poll: responseTime= {}", (Object)responseTime);
                    break;
                }
                if (reply != null) {
                    LOG.debug("response returned, but request was not accepted: {}", (Object)reply);
                }
                reason = "Invalid RADIUS reply: " + reply;
                LOG.debug(reason);
                status = PollStatus.unavailable((String)reason);
                tracker.nextAttempt();
            }
        }
        catch (Throwable e) {
            String reason = "Error while attempting to connect to the RADIUS service on " + addr.getCanonicalHostName();
            LOG.debug(reason, e);
            status = PollStatus.unavailable((String)reason);
        }
        return status;
    }

    private int convertTimeoutToSeconds(int timeout) {
        return timeout / 1000 > 0 ? timeout / 1000 : 1;
    }

    static {
        RadiusUtils.loadSecurityProvider();
    }
}

