/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.radius.detector.client;

import java.io.IOException;
import java.net.InetAddress;
import net.jradius.client.RadiusClient;
import net.jradius.client.auth.MSCHAPv2Authenticator;
import net.jradius.client.auth.RadiusAuthenticator;
import net.jradius.packet.AccessRequest;
import net.jradius.packet.RadiusPacket;
import net.jradius.packet.attribute.AttributeFactory;
import org.opennms.netmgt.provision.support.Client;
import org.opennms.protocols.radius.detector.client.CompositeAttributeLists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RadiusDetectorClient
implements Client<CompositeAttributeLists, RadiusPacket> {
    private static final Logger LOG = LoggerFactory.getLogger(RadiusDetectorClient.class);
    public static final int DEFAULT_AUTH_PORT = 1812;
    public static final int DEFAULT_ACCT_PORT = 1813;
    public static final String DEFAULT_SECRET = "secret123";
    private RadiusClient m_radiusClient;
    private int m_authport = 1812;
    private int m_acctport = 1813;
    private String m_secret = "secret123";
    private RadiusAuthenticator m_authenticator = new MSCHAPv2Authenticator();

    public void connect(InetAddress address, int port, int timeout) throws IOException, Exception {
        AttributeFactory.loadAttributeDictionary((String)"net.jradius.dictionary.AttributeDictionaryImpl");
        this.m_radiusClient = new RadiusClient(address, this.getSecret(), this.getAuthPort(), this.getAcctPort(), this.convertTimeout(timeout));
    }

    private int convertTimeout(int timeout) {
        return timeout / 1000 > 0 ? timeout / 1000 : 1;
    }

    public void close() {
        this.m_radiusClient.close();
    }

    public RadiusPacket receiveBanner() throws IOException {
        return null;
    }

    public RadiusPacket sendRequest(CompositeAttributeLists parameters) throws Exception {
        AccessRequest request = parameters.createRadiusRequest(this.getAuthenticator());
        return this.m_radiusClient.authenticate(request, this.getAuthenticator(), 0);
    }

    public void setAuthport(int authport) {
        this.m_authport = authport;
    }

    public int getAuthPort() {
        return this.m_authport;
    }

    public void setAcctPort(int acctport) {
        this.m_acctport = acctport;
    }

    public int getAcctPort() {
        return this.m_acctport;
    }

    public void setSecret(String secret) {
        this.m_secret = secret;
    }

    public String getSecret() {
        return this.m_secret;
    }

    public void setAuthenticator(RadiusAuthenticator authenticator) {
        this.m_authenticator = authenticator;
    }

    public RadiusAuthenticator getAuthenticator() {
        return this.m_authenticator;
    }
}

