/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.radius.detector.client;

import net.jradius.client.auth.EAPTTLSAuthenticator;
import net.jradius.client.auth.RadiusAuthenticator;
import net.jradius.packet.AccessRequest;
import net.jradius.packet.attribute.AttributeList;
import net.jradius.packet.attribute.RadiusAttribute;

public class CompositeAttributeLists {
    private AttributeList m_outerAttributes;
    private AttributeList m_innerAttributes;
    private String m_innerAuthType;
    private Boolean m_trustAll = true;

    public CompositeAttributeLists(AttributeList attributes) {
        this.m_outerAttributes = attributes;
    }

    public void addToInner(RadiusAttribute attribute) {
        if (this.hasNoInnerAttributes()) {
            this.setInnerAttributes(new AttributeList());
        }
        this.m_innerAttributes.add(attribute);
    }

    private void setInnerAttributes(AttributeList attributeList) {
        this.m_innerAttributes = attributeList;
    }

    public boolean hasNoInnerAttributes() {
        return this.m_innerAttributes == null;
    }

    public void setTunneledAuthType(String ttlsInnerAuthType) {
        this.m_innerAuthType = ttlsInnerAuthType;
    }

    public AccessRequest createRadiusRequest(RadiusAuthenticator radiusAuthenticator) {
        AccessRequest request = new AccessRequest();
        request.addAttributes(this.m_outerAttributes);
        if (radiusAuthenticator instanceof EAPTTLSAuthenticator) {
            ((EAPTTLSAuthenticator)radiusAuthenticator).setTunneledAttributes(this.m_innerAttributes);
            ((EAPTTLSAuthenticator)radiusAuthenticator).setInnerProtocol(this.m_innerAuthType);
            ((EAPTTLSAuthenticator)radiusAuthenticator).setTrustAll(this.m_trustAll);
        }
        return request;
    }
}

