/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.radius.springsecurity;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import net.jradius.client.RadiusClient;
import net.jradius.client.auth.PAPAuthenticator;
import net.jradius.client.auth.RadiusAuthenticator;
import net.jradius.dictionary.Attr_UserName;
import net.jradius.dictionary.Attr_UserPassword;
import net.jradius.exception.RadiusException;
import net.jradius.packet.AccessAccept;
import net.jradius.packet.AccessRequest;
import net.jradius.packet.RadiusResponse;
import net.jradius.packet.attribute.AttributeFactory;
import net.jradius.packet.attribute.AttributeList;
import net.jradius.packet.attribute.RadiusAttribute;
import org.opennms.core.utils.InetAddressUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.authentication.dao.AbstractUserDetailsAuthenticationProvider;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class RadiusAuthenticationProvider
extends AbstractUserDetailsAuthenticationProvider {
    private static final Logger LOG = LoggerFactory.getLogger(RadiusAuthenticationProvider.class);
    private String server;
    private String secret;
    private int port = 1812;
    private int timeout = 5;
    private int retries = 3;
    private Class<? extends RadiusAuthenticator> authTypeClass = null;
    private String defaultRoles = "ROLE_USER";
    private String rolesAttribute;

    public RadiusAuthenticationProvider(String server, String sharedSecret) {
        Assert.hasLength((String)server, (String)"A server must be specified");
        this.server = server;
        Assert.hasLength((String)sharedSecret, (String)"A shared secret must be specified");
        this.secret = sharedSecret;
    }

    protected void doAfterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.port, (String)"A port number must be specified");
        Assert.notNull((Object)this.timeout, (String)"A timeout must be specified");
        Assert.notNull((Object)this.retries, (String)"A retry count must be specified");
        Assert.notNull((Object)this.defaultRoles, (String)"Default Roles must be supplied in defaultRoles");
        if (this.authTypeClass == null) {
            LOG.warn("No RadiusAuthenticator provided. Falling back to {}", PAPAuthenticator.class);
        }
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }

    public void setAuthTypeClass(Class<? extends RadiusAuthenticator> authTypeClass) {
        this.authTypeClass = authTypeClass;
    }

    public void setDefaultRoles(String defaultRoles) {
        this.defaultRoles = defaultRoles;
    }

    public void setRolesAttribute(String rolesAttribute) {
        this.rolesAttribute = rolesAttribute;
    }

    protected void additionalAuthenticationChecks(UserDetails userDetails, UsernamePasswordAuthenticationToken token) throws AuthenticationException {
        if (!userDetails.getPassword().equals(token.getCredentials().toString())) {
            throw new BadCredentialsException(this.messages.getMessage("AbstractUserDetailsAuthenticationProvider.badCredentials", "Bad credentials"), (Object)userDetails);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected UserDetails retrieveUser(String username, UsernamePasswordAuthenticationToken token) throws AuthenticationException {
        void var12_17;
        RadiusResponse reply;
        if (!StringUtils.hasLength((String)username)) {
            LOG.info("Authentication attempted with empty username");
            throw new BadCredentialsException(this.messages.getMessage("RadiusAuthenticationProvider.emptyUsername", "Username cannot be empty"));
        }
        String password = (String)token.getCredentials();
        if (!StringUtils.hasLength((String)password)) {
            LOG.info("Authentication attempted with empty password");
            throw new BadCredentialsException(this.messages.getMessage("AbstractUserDetailsAuthenticationProvider.badCredentials", "Bad credentials"));
        }
        InetAddress serverIP = null;
        serverIP = InetAddressUtils.addr((String)this.server);
        if (serverIP == null) {
            LOG.error("Could not resolve radius server address {}", (Object)this.server);
            throw new AuthenticationServiceException(this.messages.getMessage("RadiusAuthenticationProvider.unknownServer", "Could not resolve radius server address"));
        }
        AttributeFactory.loadAttributeDictionary((String)"net.jradius.dictionary.AttributeDictionaryImpl");
        AttributeList attributeList = new AttributeList();
        attributeList.add((RadiusAttribute)new Attr_UserName((Serializable)((Object)username)));
        attributeList.add((RadiusAttribute)new Attr_UserPassword((Serializable)((Object)password)));
        try {
            RadiusAuthenticator authenticator = this.createAuthenticator(this.authTypeClass);
            RadiusClient radiusClient = new RadiusClient(serverIP, this.secret, this.port, this.port + 1, this.timeout);
            AccessRequest request = new AccessRequest(radiusClient, attributeList);
            LOG.debug("Sending AccessRequest message to {}:{} using {} protocol with timeout = {}, retries = {}, attributes:\n{}", new Object[]{InetAddressUtils.str((InetAddress)serverIP), this.port, authenticator.getAuthName(), this.timeout, this.retries, attributeList.toString()});
            reply = radiusClient.authenticate(request, authenticator, this.retries);
        }
        catch (RadiusException e) {
            LOG.error("Error connecting to radius server {} : {}", (Object)this.server, (Object)e);
            throw new AuthenticationServiceException(this.messages.getMessage("RadiusAuthenticationProvider.radiusError", new Object[]{e}, "Error connecting to radius server: " + (Object)((Object)e)));
        }
        catch (IOException e) {
            LOG.error("Error connecting to radius server {} : {}", (Object)this.server, (Object)e);
            throw new AuthenticationServiceException(this.messages.getMessage("RadiusAuthenticationProvider.radiusError", new Object[]{e}, "Error connecting to radius server: " + e));
        }
        catch (IllegalAccessException | InstantiationException e) {
            LOG.error("Error instantiating configured RadiusAuthenticator {}", this.authTypeClass, (Object)e);
            throw new AuthenticationServiceException(this.messages.getMessage("RadiusAuthenticationProvider.radiusError", new Object[]{e}, "Error connecting to radius server: " + e));
        }
        if (reply == null) {
            LOG.error("Timed out connecting to radius server {}", (Object)this.server);
            throw new AuthenticationServiceException(this.messages.getMessage("RadiusAuthenticationProvider.radiusTimeout", "Timed out connecting to radius server"));
        }
        if (!(reply instanceof AccessAccept)) {
            LOG.info("Received a reply other than AccessAccept from radius server {} for user {} :\n{}", new Object[]{this.server, username, reply.toString()});
            throw new BadCredentialsException(this.messages.getMessage("AbstractUserDetailsAuthenticationProvider.badCredentials", "Bad credentials"));
        }
        LOG.debug("Received AccessAccept message from {}:{} for user {} with attributes:\n{}", new Object[]{InetAddressUtils.str((InetAddress)serverIP), this.port, username, reply.getAttributes().toString()});
        String roles = null;
        if (!StringUtils.hasLength((String)this.rolesAttribute)) {
            LOG.debug("rolesAttribute not set, using default roles ({}) for user {}", (Object)this.defaultRoles, (Object)username);
            roles = new String(this.defaultRoles);
        } else {
            for (RadiusAttribute attribute : reply.getAttributes().getAttributeList()) {
                if (!this.rolesAttribute.equals(attribute.getAttributeName())) continue;
                roles = new String(attribute.getValue().getBytes());
                break;
            }
            if (roles == null) {
                LOG.info("Radius attribute {} not found, using default roles ({}) for user {}", new Object[]{this.rolesAttribute, this.defaultRoles, username});
                roles = new String(this.defaultRoles);
            }
        }
        String[] rolesArray = roles.replaceAll("\\s*", "").split(",");
        ArrayList<SimpleGrantedAuthority> authorities = new ArrayList<SimpleGrantedAuthority>(rolesArray.length);
        String[] stringArray = rolesArray;
        int n = stringArray.length;
        boolean bl = false;
        while (var12_17 < n) {
            String role = stringArray[var12_17];
            authorities.add(new SimpleGrantedAuthority(role));
            ++var12_17;
        }
        StringBuffer readRoles = new StringBuffer();
        for (GrantedAuthority grantedAuthority : authorities) {
            readRoles.append(grantedAuthority.toString() + ", ");
        }
        if (readRoles.length() > 0) {
            readRoles.delete(readRoles.length() - 2, readRoles.length());
        }
        LOG.debug("Parsed roles {} for user {}", (Object)readRoles, (Object)username);
        return new User(username, password, true, true, true, true, authorities);
    }

    private RadiusAuthenticator createAuthenticator(Class<? extends RadiusAuthenticator> authTypeClass) throws IllegalAccessException, InstantiationException {
        if (authTypeClass == null) {
            return new PAPAuthenticator();
        }
        return authTypeClass.newInstance();
    }
}

