/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.radius.springsecurity;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import net.jradius.client.RadiusClient;
import net.jradius.client.auth.PAPAuthenticator;
import net.jradius.client.auth.RadiusAuthenticator;
import net.jradius.dictionary.Attr_UserName;
import net.jradius.dictionary.Attr_UserPassword;
import net.jradius.exception.RadiusException;
import net.jradius.packet.AccessAccept;
import net.jradius.packet.AccessRequest;
import net.jradius.packet.RadiusResponse;
import net.jradius.packet.attribute.AttributeFactory;
import net.jradius.packet.attribute.AttributeList;
import net.jradius.packet.attribute.RadiusAttribute;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.opennms.core.utils.InetAddressUtils;
import org.springframework.security.AuthenticationException;
import org.springframework.security.AuthenticationServiceException;
import org.springframework.security.BadCredentialsException;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.security.providers.UsernamePasswordAuthenticationToken;
import org.springframework.security.providers.dao.AbstractUserDetailsAuthenticationProvider;
import org.springframework.security.userdetails.User;
import org.springframework.security.userdetails.UserDetails;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class RadiusAuthenticationProvider
extends AbstractUserDetailsAuthenticationProvider {
    private static final Log logger = LogFactory.getLog(RadiusAuthenticationProvider.class);
    private String server;
    private String secret;
    private int port = 1812;
    private int timeout = 5;
    private int retries = 3;
    private RadiusAuthenticator authTypeClass = new PAPAuthenticator();
    private String defaultRoles = "ROLE_USER";
    private String rolesAttribute;

    public RadiusAuthenticationProvider(String server, String secret) {
        Assert.hasLength((String)server, (String)"A server must be specified");
        this.server = server;
        Assert.hasLength((String)secret, (String)"A shared secret must be specified");
        this.secret = secret;
    }

    protected void doAfterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.port, (String)"A port number must be specified");
        Assert.notNull((Object)this.timeout, (String)"A timeout must be specified");
        Assert.notNull((Object)this.retries, (String)"A retry count must be specified");
        Assert.notNull((Object)this.authTypeClass, (String)"A RadiusAuthenticator object must be supplied in authTypeClass");
        Assert.notNull((Object)this.defaultRoles, (String)"Default Roles must be supplied in defaultRoles");
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }

    public void setAuthTypeClass(RadiusAuthenticator authTypeClass) {
        this.authTypeClass = authTypeClass;
    }

    public void setDefaultRoles(String defaultRoles) {
        this.defaultRoles = defaultRoles;
    }

    public void setRolesAttribute(String rolesAttribute) {
        this.rolesAttribute = rolesAttribute;
    }

    protected void additionalAuthenticationChecks(UserDetails userDetails, UsernamePasswordAuthenticationToken token) throws AuthenticationException {
        if (!userDetails.getPassword().equals(token.getCredentials().toString())) {
            throw new BadCredentialsException(this.messages.getMessage("AbstractUserDetailsAuthenticationProvider.badCredentials", "Bad credentials"), (Object)userDetails);
        }
    }

    protected UserDetails retrieveUser(String username, UsernamePasswordAuthenticationToken token) throws AuthenticationException {
        RadiusResponse reply;
        if (!StringUtils.hasLength((String)username)) {
            logger.info((Object)"Authentication attempted with empty username");
            throw new BadCredentialsException(this.messages.getMessage("RadiusAuthenticationProvider.emptyUsername", "Username cannot be empty"));
        }
        String password = (String)token.getCredentials();
        if (!StringUtils.hasLength((String)password)) {
            logger.info((Object)"Authentication attempted with empty password");
            throw new BadCredentialsException(this.messages.getMessage("AbstractUserDetailsAuthenticationProvider.badCredentials", "Bad credentials"));
        }
        InetAddress serverIP = null;
        serverIP = InetAddressUtils.addr((String)this.server);
        if (serverIP == null) {
            logger.error((Object)("Could not resolve radius server address " + this.server));
            throw new AuthenticationServiceException(this.messages.getMessage("RadiusAuthenticationProvider.unknownServer", "Could not resolve radius server address"));
        }
        AttributeFactory.loadAttributeDictionary((String)"net.jradius.dictionary.AttributeDictionaryImpl");
        AttributeList attributeList = new AttributeList();
        attributeList.add((RadiusAttribute)new Attr_UserName((Serializable)((Object)username)));
        attributeList.add((RadiusAttribute)new Attr_UserPassword((Serializable)((Object)password)));
        try {
            RadiusClient radiusClient = new RadiusClient(serverIP, this.secret, this.port, this.port + 1, this.timeout);
            AccessRequest request = new AccessRequest(radiusClient, attributeList);
            logger.debug((Object)("Sending AccessRequest message to " + InetAddressUtils.str((InetAddress)serverIP) + ":" + this.port + " using " + this.authTypeClass.getAuthName() + " protocol with timeout = " + this.timeout + ", retries = " + this.retries + ", attributes:\n" + attributeList.toString()));
            reply = radiusClient.authenticate(request, this.authTypeClass, this.retries);
        }
        catch (RadiusException e) {
            logger.error((Object)("Error connecting to radius server " + this.server + " : " + (Object)((Object)e)));
            throw new AuthenticationServiceException(this.messages.getMessage("RadiusAuthenticationProvider.radiusError", new Object[]{e}, "Error connecting to radius server: " + (Object)((Object)e)));
        }
        catch (IOException e) {
            logger.error((Object)("Error connecting to radius server " + this.server + " : " + e));
            throw new AuthenticationServiceException(this.messages.getMessage("RadiusAuthenticationProvider.radiusError", new Object[]{e}, "Error connecting to radius server: " + e));
        }
        if (reply == null) {
            logger.error((Object)("Timed out connecting to radius server " + this.server));
            throw new AuthenticationServiceException(this.messages.getMessage("RadiusAuthenticationProvider.radiusTimeout", "Timed out connecting to radius server"));
        }
        if (!(reply instanceof AccessAccept)) {
            logger.info((Object)("Received a reply other than AccessAccept from radius server " + this.server + " for user " + username + " :\n" + reply.toString()));
            throw new BadCredentialsException(this.messages.getMessage("AbstractUserDetailsAuthenticationProvider.badCredentials", "Bad credentials"));
        }
        logger.debug((Object)("Received AccessAccept message from " + InetAddressUtils.str((InetAddress)serverIP) + ":" + this.port + " for user " + username + " with attributes:\n" + reply.getAttributes().toString()));
        String roles = null;
        if (!StringUtils.hasLength((String)this.rolesAttribute)) {
            logger.debug((Object)("rolesAttribute not set, using default roles (" + this.defaultRoles + ") for user " + username));
            roles = new String(this.defaultRoles);
        } else {
            for (RadiusAttribute attribute : reply.getAttributes().getAttributeList()) {
                if (!this.rolesAttribute.equals(attribute.getAttributeName())) continue;
                roles = new String(attribute.getValue().getBytes());
                break;
            }
            if (roles == null) {
                logger.info((Object)("Radius attribute " + this.rolesAttribute + " not found, using default roles (" + this.defaultRoles + ") for user " + username));
                roles = new String(this.defaultRoles);
            }
        }
        String[] rolesArray = roles.replaceAll("\\s*", "").split(",");
        GrantedAuthority[] authorities = new GrantedAuthority[rolesArray.length];
        for (int i = 0; i < rolesArray.length; ++i) {
            authorities[i] = new GrantedAuthorityImpl(rolesArray[i]);
        }
        if (logger.isDebugEnabled()) {
            StringBuffer readRoles = new StringBuffer();
            for (GrantedAuthority authority : authorities) {
                readRoles.append(authority.toString() + ", ");
            }
            if (readRoles.length() > 0) {
                readRoles.delete(readRoles.length() - 2, readRoles.length());
            }
            logger.debug((Object)("Parsed roles " + readRoles + " for user " + username));
        }
        return new User(username, password, true, true, true, true, authorities);
    }
}

