/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.radius.monitor;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.Map;
import net.jradius.client.RadiusClient;
import net.jradius.client.auth.CHAPAuthenticator;
import net.jradius.client.auth.EAPMD5Authenticator;
import net.jradius.client.auth.EAPMSCHAPv2Authenticator;
import net.jradius.client.auth.MSCHAPv1Authenticator;
import net.jradius.client.auth.MSCHAPv2Authenticator;
import net.jradius.client.auth.PAPAuthenticator;
import net.jradius.client.auth.RadiusAuthenticator;
import net.jradius.dictionary.Attr_NASIdentifier;
import net.jradius.dictionary.Attr_UserName;
import net.jradius.dictionary.Attr_UserPassword;
import net.jradius.packet.AccessAccept;
import net.jradius.packet.AccessRequest;
import net.jradius.packet.RadiusResponse;
import net.jradius.packet.attribute.AttributeFactory;
import net.jradius.packet.attribute.AttributeList;
import net.jradius.packet.attribute.RadiusAttribute;
import org.apache.log4j.Level;
import org.opennms.core.utils.LogUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.TimeoutTracker;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.poller.monitors.AbstractServiceMonitor;

@Distributable
public final class RadiusAuthMonitor
extends AbstractServiceMonitor {
    public static final int DEFAULT_TIMEOUT = 5000;
    public static final int DEFAULT_RETRY = 0;
    public static final int DEFAULT_AUTH_PORT = 1812;
    public static final int DEFAULT_ACCT_PORT = 1813;
    public static final String DEFAULT_AUTH_TYPE = "pap";
    public static final String DEFAULT_USER = "OpenNMS";
    public static final String DEFAULT_PASSWORD = "OpenNMS";
    public static final String DEFAULT_SECRET = "secret";
    public static final String DEFAULT_NASID = "opennms";

    public RadiusAuthMonitor() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        LogUtils.infof((Object)((Object)this), (String)"RadiusAuthMonitor class loaded", (Object[])new Object[0]);
    }

    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        NetworkInterface iface = svc.getNetInterface();
        PollStatus status = PollStatus.unavailable();
        if (parameters == null) {
            throw new NullPointerException();
        }
        TimeoutTracker tracker = new TimeoutTracker(parameters, 0, 5000);
        int authport = ParameterMap.getKeyedInteger(parameters, (String)"authport", (int)1812);
        int acctport = ParameterMap.getKeyedInteger(parameters, (String)"acctport", (int)1813);
        String user = ParameterMap.getKeyedString(parameters, (String)"user", (String)"OpenNMS");
        String password = ParameterMap.getKeyedString(parameters, (String)"password", (String)"OpenNMS");
        String secret = ParameterMap.getKeyedString(parameters, (String)DEFAULT_SECRET, (String)DEFAULT_SECRET);
        String authType = ParameterMap.getKeyedString(parameters, (String)"authtype", (String)DEFAULT_AUTH_TYPE);
        String nasid = ParameterMap.getKeyedString(parameters, (String)"nasid", (String)DEFAULT_NASID);
        InetAddress addr = (InetAddress)iface.getAddress();
        AttributeFactory.loadAttributeDictionary((String)"net.jradius.dictionary.AttributeDictionaryImpl");
        int timeout = this.convertTimeoutToSeconds(ParameterMap.getKeyedInteger(parameters, (String)"timeout", (int)5000));
        try {
            RadiusClient rc = new RadiusClient(addr, secret, authport, acctport, timeout);
            tracker.reset();
            while (tracker.shouldRetry()) {
                CHAPAuthenticator auth;
                AttributeList attributes = new AttributeList();
                attributes.add((RadiusAttribute)new Attr_UserName((Serializable)((Object)user)));
                attributes.add((RadiusAttribute)new Attr_NASIdentifier((Serializable)((Object)nasid)));
                attributes.add((RadiusAttribute)new Attr_UserPassword((Serializable)((Object)password)));
                AccessRequest accessRequest = new AccessRequest(rc, attributes);
                if (authType.equalsIgnoreCase("chap")) {
                    auth = new CHAPAuthenticator();
                } else if (authType.equalsIgnoreCase(DEFAULT_AUTH_TYPE)) {
                    auth = new PAPAuthenticator();
                } else if (authType.equalsIgnoreCase("mschapv1")) {
                    auth = new MSCHAPv1Authenticator();
                } else if (authType.equalsIgnoreCase("mschapv2")) {
                    auth = new MSCHAPv2Authenticator();
                } else if (authType.equalsIgnoreCase("eapmd5") || authType.equalsIgnoreCase("eap-md5")) {
                    auth = new EAPMD5Authenticator();
                } else if (authType.equalsIgnoreCase("eapmschapv2") || authType.equalsIgnoreCase("eap-mschapv2")) {
                    auth = new EAPMSCHAPv2Authenticator();
                } else {
                    return this.logDown(Level.ERROR, "Unknown authenticator type '" + authType + "'");
                }
                tracker.startAttempt();
                RadiusResponse reply = rc.authenticate(accessRequest, (RadiusAuthenticator)auth, ParameterMap.getKeyedInteger(parameters, (String)"retry", (int)0));
                if (reply instanceof AccessAccept) {
                    double responseTime = tracker.elapsedTimeInMillis();
                    status = PollStatus.available((Double)responseTime);
                    LogUtils.debugf((Object)((Object)this), (String)"Radius service is AVAILABLE on: %s", (Object[])new Object[]{addr.getCanonicalHostName()});
                    LogUtils.debugf((Object)((Object)this), (String)"poll: responseTime= %fms", (Object[])new Object[]{responseTime});
                    break;
                }
                if (reply != null) {
                    LogUtils.debugf((Object)((Object)this), (String)"response returned, but request was not accepted: %s", (Object[])new Object[]{reply});
                }
                status = this.logDown(Level.ERROR, "Invalid RADIUS reply: " + reply);
                tracker.nextAttempt();
            }
        }
        catch (Throwable e) {
            status = this.logDown(Level.ERROR, "Error while attempting to connect to the RADIUS service on " + addr.getCanonicalHostName(), e);
        }
        return status;
    }

    private int convertTimeoutToSeconds(int timeout) {
        return timeout / 1000 > 0 ? timeout / 1000 : 1;
    }
}

