/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.radius.capsd;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.Map;
import net.jradius.client.RadiusClient;
import net.jradius.client.auth.CHAPAuthenticator;
import net.jradius.client.auth.EAPMD5Authenticator;
import net.jradius.client.auth.EAPMSCHAPv2Authenticator;
import net.jradius.client.auth.MSCHAPv1Authenticator;
import net.jradius.client.auth.MSCHAPv2Authenticator;
import net.jradius.client.auth.PAPAuthenticator;
import net.jradius.client.auth.RadiusAuthenticator;
import net.jradius.dictionary.Attr_NASIdentifier;
import net.jradius.dictionary.Attr_UserName;
import net.jradius.dictionary.Attr_UserPassword;
import net.jradius.packet.AccessAccept;
import net.jradius.packet.AccessRequest;
import net.jradius.packet.RadiusResponse;
import net.jradius.packet.attribute.AttributeFactory;
import net.jradius.packet.attribute.AttributeList;
import net.jradius.packet.attribute.RadiusAttribute;
import org.opennms.core.utils.LogUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.capsd.AbstractPlugin;

public final class RadiusAuthPlugin
extends AbstractPlugin {
    private static final String PROTOCOL_NAME = "RadiusAuth";
    public static final int DEFAULT_TIMEOUT = 5000;
    public static final int DEFAULT_RETRY = 0;
    public static final int DEFAULT_AUTH_PORT = 1812;
    public static final int DEFAULT_ACCT_PORT = 1813;
    public static final String DEFAULT_AUTH_TYPE = "pap";
    public static final String DEFAULT_USER = "OpenNMS";
    public static final String DEFAULT_PASSWORD = "OpenNMS";
    public static final String DEFAULT_SECRET = "secret";
    public static final String DEFAULT_NAS_ID = "opennms";

    private boolean isRadius(InetAddress host, int authport, int acctport, String authType, String user, String password, String secret, String nasid, int retry, int timeout) {
        boolean isRadiusServer = false;
        AttributeFactory.loadAttributeDictionary((String)"net.jradius.dictionary.AttributeDictionaryImpl");
        try {
            CHAPAuthenticator auth;
            RadiusClient rc = new RadiusClient(host, secret, authport, acctport, this.convertTimeoutToSeconds(timeout));
            AttributeList attributes = new AttributeList();
            attributes.add((RadiusAttribute)new Attr_UserName((Serializable)((Object)user)));
            attributes.add((RadiusAttribute)new Attr_NASIdentifier((Serializable)((Object)nasid)));
            attributes.add((RadiusAttribute)new Attr_UserPassword((Serializable)((Object)password)));
            AccessRequest accessRequest = new AccessRequest(rc, attributes);
            if (authType.equalsIgnoreCase("chap")) {
                auth = new CHAPAuthenticator();
            } else if (authType.equalsIgnoreCase(DEFAULT_AUTH_TYPE)) {
                auth = new PAPAuthenticator();
            } else if (authType.equalsIgnoreCase("mschapv1")) {
                auth = new MSCHAPv1Authenticator();
            } else if (authType.equalsIgnoreCase("mschapv2")) {
                auth = new MSCHAPv2Authenticator();
            } else if (authType.equalsIgnoreCase("eapmd5")) {
                auth = new EAPMD5Authenticator();
            } else if (authType.equalsIgnoreCase("eapmschapv2")) {
                auth = new EAPMSCHAPv2Authenticator();
            } else {
                LogUtils.warnf((Object)((Object)this), (String)"Unknown authenticator type '%s'", (Object[])new Object[]{authType});
                return isRadiusServer;
            }
            RadiusResponse reply = rc.authenticate(accessRequest, (RadiusAuthenticator)auth, retry);
            isRadiusServer = reply instanceof AccessAccept;
            LogUtils.debugf((Object)((Object)this), (String)"Discovered RADIUS service on %s", (Object[])new Object[]{host.getCanonicalHostName()});
        }
        catch (Throwable e) {
            LogUtils.debugf((Object)((Object)this), (Throwable)e, (String)"Error while attempting to discover RADIUS service on %s", (Object[])new Object[]{host.getCanonicalHostName()});
            isRadiusServer = false;
        }
        return isRadiusServer;
    }

    public String getProtocolName() {
        return PROTOCOL_NAME;
    }

    public boolean isProtocolSupported(InetAddress address) {
        return this.isRadius(address, 1812, 1813, DEFAULT_AUTH_TYPE, "OpenNMS", "OpenNMS", DEFAULT_SECRET, DEFAULT_NAS_ID, 0, 5000);
    }

    public boolean isProtocolSupported(InetAddress address, Map<String, Object> qualifiers) {
        int authport = 1812;
        int acctport = 1813;
        String authType = DEFAULT_AUTH_TYPE;
        int timeout = 5000;
        int retry = 0;
        String user = "OpenNMS";
        String password = "OpenNMS";
        String secret = DEFAULT_SECRET;
        String nasid = DEFAULT_NAS_ID;
        if (qualifiers != null) {
            authport = ParameterMap.getKeyedInteger(qualifiers, (String)"authport", (int)1812);
            acctport = ParameterMap.getKeyedInteger(qualifiers, (String)"acctport", (int)1813);
            authType = ParameterMap.getKeyedString(qualifiers, (String)"authtype", (String)DEFAULT_AUTH_TYPE);
            timeout = ParameterMap.getKeyedInteger(qualifiers, (String)"timeout", (int)5000);
            retry = ParameterMap.getKeyedInteger(qualifiers, (String)"retry", (int)0);
            user = ParameterMap.getKeyedString(qualifiers, (String)"user", (String)"OpenNMS");
            password = ParameterMap.getKeyedString(qualifiers, (String)"password", (String)"OpenNMS");
            secret = ParameterMap.getKeyedString(qualifiers, (String)DEFAULT_SECRET, (String)DEFAULT_SECRET);
            nasid = ParameterMap.getKeyedString(qualifiers, (String)"nasid", (String)DEFAULT_NAS_ID);
        }
        return this.isRadius(address, authport, acctport, authType, user, password, secret, nasid, retry, timeout);
    }

    private int convertTimeoutToSeconds(int timeout) {
        return timeout / 1000 > 0 ? timeout / 1000 : 1;
    }
}

