/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.radius.detector;

import java.io.Serializable;
import net.jradius.client.auth.CHAPAuthenticator;
import net.jradius.client.auth.EAPMD5Authenticator;
import net.jradius.client.auth.EAPMSCHAPv2Authenticator;
import net.jradius.client.auth.MSCHAPv1Authenticator;
import net.jradius.client.auth.MSCHAPv2Authenticator;
import net.jradius.client.auth.PAPAuthenticator;
import net.jradius.client.auth.RadiusAuthenticator;
import net.jradius.dictionary.Attr_NASIdentifier;
import net.jradius.dictionary.Attr_UserName;
import net.jradius.dictionary.Attr_UserPassword;
import net.jradius.packet.AccessAccept;
import net.jradius.packet.AccessChallenge;
import net.jradius.packet.AccessReject;
import net.jradius.packet.RadiusPacket;
import net.jradius.packet.attribute.AttributeList;
import net.jradius.packet.attribute.RadiusAttribute;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.provision.support.BasicDetector;
import org.opennms.netmgt.provision.support.Client;
import org.opennms.netmgt.provision.support.RequestBuilder;
import org.opennms.netmgt.provision.support.ResponseValidator;
import org.opennms.protocols.radius.detector.client.RadiusDetectorClient;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class RadiusAuthDetector
extends BasicDetector<AttributeList, RadiusPacket> {
    private static final String DEFAULT_SERVICE_NAME = "RadiusAuth";
    public static final int DEFAULT_AUTH_PORT = 1812;
    public static final int DEFAULT_ACCT_PORT = 1813;
    public static final String DEFAULT_AUTH_TYPE = "pap";
    public static final String DEFAULT_USER = "OpenNMS";
    public static final String DEFAULT_PASSWORD = "OpenNMS";
    public static final String DEFAULT_SECRET = "secret";
    public static final String DEFAULT_NAS_ID = "opennms";
    private int m_authport = 1812;
    private int m_acctport = 1813;
    private String m_secret = "secret";
    private String m_authType = "pap";
    private String m_nasid = "opennms";
    private String m_user = "OpenNMS";
    private String m_password = "OpenNMS";

    protected RadiusAuthDetector() {
        super(DEFAULT_SERVICE_NAME, 1812);
    }

    protected RadiusAuthDetector(String serviceName, int port) {
        super(serviceName, port);
    }

    public void onInit() {
        this.send(RadiusAuthDetector.request(this.getNasID(), this.getUser(), this.getPassword()), RadiusAuthDetector.expectValidResponse(AccessAccept.class, AccessChallenge.class, AccessReject.class));
    }

    private static ResponseValidator<RadiusPacket> expectValidResponse(final Class<?> accept, final Class<?> challenge, final Class<?> reject) {
        return new ResponseValidator<RadiusPacket>(){

            public boolean validate(RadiusPacket response) {
                return accept.isInstance(response) || challenge.isInstance(response) || reject.isInstance(response);
            }
        };
    }

    private static RequestBuilder<AttributeList> request(final String nasID, final String user, final String password) {
        LogUtils.debugf(RadiusAuthDetector.class, (String)"request: nasID = %s, user = %s, password = %s", (Object[])new Object[]{nasID, user, password});
        return new RequestBuilder<AttributeList>(){

            public AttributeList getRequest() {
                AttributeList attributes = new AttributeList();
                attributes.add((RadiusAttribute)new Attr_UserName((Serializable)((Object)user)));
                attributes.add((RadiusAttribute)new Attr_NASIdentifier((Serializable)((Object)nasID)));
                attributes.add((RadiusAttribute)new Attr_UserPassword((Serializable)((Object)password)));
                return attributes;
            }
        };
    }

    protected Client<AttributeList, RadiusPacket> getClient() {
        RadiusDetectorClient rdc = new RadiusDetectorClient();
        rdc.setAuthport(this.getAuthPort());
        rdc.setAcctPort(this.getAcctPort());
        rdc.setSecret(this.getSecret());
        rdc.setAuthenticator(this.getAuthenticator());
        return rdc;
    }

    public void setAuthPort(int authport) {
        this.m_authport = authport;
    }

    public int getAuthPort() {
        return this.m_authport;
    }

    public void setAcctPort(int acctport) {
        this.m_acctport = acctport;
    }

    public int getAcctPort() {
        return this.m_acctport;
    }

    public void setSecret(String secret) {
        this.m_secret = secret;
    }

    public String getSecret() {
        return this.m_secret;
    }

    public void setAuthType(String authType) {
        this.m_authType = authType;
    }

    public String getAuthType() {
        return this.m_authType;
    }

    public RadiusAuthenticator getAuthenticator() {
        String authType = this.getAuthType();
        Object auth = authType.equalsIgnoreCase("chap") ? new CHAPAuthenticator() : (authType.equalsIgnoreCase(DEFAULT_AUTH_TYPE) ? new PAPAuthenticator() : (authType.equalsIgnoreCase("mschapv1") ? new MSCHAPv1Authenticator() : (authType.equalsIgnoreCase("mschapv2") ? new MSCHAPv2Authenticator() : (authType.equalsIgnoreCase("eapmd5") || authType.equalsIgnoreCase("eap-md5") ? new EAPMD5Authenticator() : (authType.equalsIgnoreCase("eapmschapv2") || authType.equalsIgnoreCase("eap-mschapv2") ? new EAPMSCHAPv2Authenticator() : null)))));
        return auth;
    }

    public void setNasID(String nasid) {
        this.m_nasid = nasid;
    }

    public String getNasID() {
        return this.m_nasid;
    }

    public void setUser(String user) {
        this.m_user = user;
    }

    public String getUser() {
        return this.m_user;
    }

    public void setPassword(String password) {
        this.m_password = password;
    }

    public String getPassword() {
        return this.m_password;
    }
}

