/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.nsclient.detector.client;

import java.io.IOException;
import java.net.InetAddress;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.provision.support.Client;
import org.opennms.protocols.nsclient.NsclientException;
import org.opennms.protocols.nsclient.NsclientManager;
import org.opennms.protocols.nsclient.NsclientPacket;
import org.opennms.protocols.nsclient.detector.request.NsclientRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NsclientClient
implements Client<NsclientRequest, NsclientPacket> {
    private static final Logger LOG = LoggerFactory.getLogger(NsclientClient.class);
    private String password;
    private NsclientManager client;

    public void connect(InetAddress address, int port, int timeout) throws IOException, Exception {
        this.client = new NsclientManager(InetAddressUtils.str((InetAddress)address), port, this.password);
        this.client.setTimeout(timeout);
        this.client.init();
    }

    public void close() {
        this.client.close();
    }

    public NsclientPacket receiveBanner() throws IOException, Exception {
        return null;
    }

    public NsclientPacket sendRequest(NsclientRequest request) throws IOException, Exception {
        boolean isAServer = false;
        NsclientPacket response = null;
        for (int attempts = 0; attempts <= request.getRetries() && !isAServer; ++attempts) {
            try {
                response = this.client.processCheckCommand(request.getFormattedCommand(), request.getCheckParams());
                LOG.debug("sendRequest: {}: {}", (Object)request.getFormattedCommand(), (Object)response.getResponse());
                isAServer = true;
                continue;
            }
            catch (NsclientException e) {
                StringBuffer message = new StringBuffer();
                message.append("sendRequest: Check failed... NsclientManager returned exception: ");
                message.append(e.getMessage());
                message.append(" : ");
                message.append(e.getCause() == null ? "" : e.getCause().getMessage());
                LOG.info(message.toString());
                isAServer = false;
            }
        }
        return response;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

