/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.nsclient.monitor;

import java.net.InetAddress;
import java.util.Map;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.TimeoutTracker;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.monitors.AbstractServiceMonitor;
import org.opennms.protocols.nsclient.NsclientCheckParams;
import org.opennms.protocols.nsclient.NsclientException;
import org.opennms.protocols.nsclient.NsclientManager;
import org.opennms.protocols.nsclient.NsclientPacket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Distributable
public class NsclientMonitor
extends AbstractServiceMonitor {
    private static final Logger LOG = LoggerFactory.getLogger(NsclientMonitor.class);
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 3000;

    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        String reason = null;
        int serviceStatus = 3;
        NsclientPacket response = null;
        Double responseTime = null;
        String command = ParameterMap.getKeyedString(parameters, (String)"command", (String)NsclientManager.convertTypeToString("1"));
        int port = ParameterMap.getKeyedInteger(parameters, (String)"port", (int)1248);
        String password = ParameterMap.getKeyedString(parameters, (String)"password", (String)"None");
        String params = ParameterMap.getKeyedString(parameters, (String)"parameter", null);
        int critPerc = ParameterMap.getKeyedInteger(parameters, (String)"criticalPercent", (int)0);
        int warnPerc = ParameterMap.getKeyedInteger(parameters, (String)"warningPercent", (int)0);
        TimeoutTracker tracker = new TimeoutTracker(parameters, 0, 3000);
        InetAddress ipAddr = svc.getAddress();
        tracker.reset();
        while (tracker.shouldRetry() && serviceStatus != 1) {
            try {
                tracker.startAttempt();
                NsclientManager client = new NsclientManager(InetAddressUtils.str((InetAddress)ipAddr), port, password);
                client.setTimeout(tracker.getSoTimeout());
                client.setPassword(password);
                client.init();
                NsclientCheckParams clientParams = new NsclientCheckParams(critPerc, warnPerc, params);
                response = client.processCheckCommand(NsclientManager.convertStringToType(command), clientParams);
                responseTime = tracker.elapsedTimeInMillis();
                if (response != null) {
                    if (response.getResultCode() == 0) {
                        serviceStatus = 1;
                        reason = response.getResponse();
                    } else if (response.getResultCode() == 2) {
                        serviceStatus = 2;
                        reason = response.getResponse();
                        responseTime = null;
                    }
                }
            }
            catch (NsclientException e) {
                LOG.debug("Nsclient Poller received exception from client", (Throwable)e);
                reason = "NsclientException: " + e.getMessage();
            }
            tracker.nextAttempt();
        }
        return PollStatus.get((int)serviceStatus, reason, responseTime);
    }
}

