/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.nsclient.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.io.IOUtils;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.xml.CastorUtils;
import org.opennms.netmgt.config.nsclient.NsclientCollection;
import org.opennms.netmgt.config.nsclient.NsclientDatacollectionConfig;
import org.opennms.netmgt.model.RrdRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NSClientDataCollectionConfigFactory {
    private static final Logger LOG = LoggerFactory.getLogger(NSClientDataCollectionConfigFactory.class);
    private final ReadWriteLock m_globalLock = new ReentrantReadWriteLock();
    private final Lock m_readLock = this.m_globalLock.readLock();
    private final Lock m_writeLock = this.m_globalLock.writeLock();
    private static NSClientDataCollectionConfigFactory m_instance;
    private static boolean m_loadedFromFile;
    protected static long m_lastModified;
    private NsclientDatacollectionConfig m_config;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NSClientDataCollectionConfigFactory(String configFile) throws MarshalException, ValidationException, IOException {
        FileInputStream is = null;
        try {
            is = new FileInputStream(configFile);
            this.initialize(is);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)is);
    }

    public Lock getReadLock() {
        return this.m_readLock;
    }

    public Lock getWriteLock() {
        return this.m_writeLock;
    }

    private void initialize(InputStream stream) throws MarshalException, ValidationException {
        LOG.debug("initialize: initializing NSCLient collection config factory.");
        this.m_config = (NsclientDatacollectionConfig)CastorUtils.unmarshal(NsclientDatacollectionConfig.class, (InputStream)stream);
    }

    public static synchronized void init() throws IOException, FileNotFoundException, MarshalException, ValidationException {
        if (m_instance == null) {
            File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.NSCLIENT_COLLECTION_CONFIG_FILE_NAME);
            m_instance = new NSClientDataCollectionConfigFactory(cfgFile.getPath());
            m_lastModified = cfgFile.lastModified();
            m_loadedFromFile = true;
        }
    }

    public static synchronized NSClientDataCollectionConfigFactory getInstance() {
        if (m_instance == null) {
            throw new IllegalStateException("You must call NSClientCollectionConfigFactory.init() before calling getInstance().");
        }
        return m_instance;
    }

    public static synchronized void setInstance(NSClientDataCollectionConfigFactory instance) {
        m_instance = instance;
        m_loadedFromFile = false;
    }

    public synchronized void reload() throws IOException, FileNotFoundException, MarshalException, ValidationException {
        m_instance = null;
        NSClientDataCollectionConfigFactory.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NsclientCollection getNSClientCollection(String collectionName) {
        try {
            this.getReadLock().lock();
            NsclientCollection collection = null;
            for (NsclientCollection coll : this.m_config.getNsclientCollection()) {
                if (!coll.getName().equalsIgnoreCase(collectionName)) continue;
                collection = coll;
                break;
            }
            if (collection == null) {
                throw new IllegalArgumentException("getNSClientCollection: collection name: " + collectionName + " specified in collectd configuration not found in nsclient collection configuration.");
            }
            NsclientCollection nsclientCollection = collection;
            return nsclientCollection;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RrdRepository getRrdRepository(String collectionName) {
        try {
            this.getReadLock().lock();
            RrdRepository repo = new RrdRepository();
            repo.setRrdBaseDir(new File(this.getRrdPath()));
            repo.setRraList(this.getRRAList(collectionName));
            repo.setStep(this.getStep(collectionName));
            repo.setHeartBeat(2 * this.getStep(collectionName));
            RrdRepository rrdRepository = repo;
            return rrdRepository;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStep(String cName) {
        try {
            this.getReadLock().lock();
            NsclientCollection collection = this.getNSClientCollection(cName);
            if (collection != null) {
                int n = collection.getRrd().getStep();
                return n;
            }
            int n = -1;
            return n;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getRRAList(String cName) {
        try {
            this.getReadLock().lock();
            NsclientCollection collection = this.getNSClientCollection(cName);
            if (collection != null) {
                List<String> list = collection.getRrd().getRraCollection();
                return list;
            }
            List<String> list = null;
            return list;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRrdPath() {
        try {
            this.getReadLock().lock();
            String rrdPath = this.m_config.getRrdRepository();
            if (rrdPath == null) {
                throw new RuntimeException("Configuration error, failed to retrieve path to RRD repository.");
            }
            if (rrdPath.endsWith(File.separator)) {
                rrdPath = rrdPath.substring(0, rrdPath.length() - File.separator.length());
            }
            String string = rrdPath;
            return string;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateFromFile() throws IOException, MarshalException, ValidationException {
        if (m_loadedFromFile) {
            try {
                this.getWriteLock().lock();
                File surveillanceViewsFile = ConfigFileConstants.getFile((int)ConfigFileConstants.NSCLIENT_COLLECTION_CONFIG_FILE_NAME);
                if (m_lastModified != surveillanceViewsFile.lastModified()) {
                    this.reload();
                }
            }
            finally {
                this.getWriteLock().unlock();
            }
        }
    }

    static {
        m_loadedFromFile = false;
    }
}

