/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.nsclient.detector;

import org.opennms.netmgt.provision.support.BasicDetector;
import org.opennms.netmgt.provision.support.Client;
import org.opennms.netmgt.provision.support.ClientConversation;
import org.opennms.protocols.nsclient.NsclientManager;
import org.opennms.protocols.nsclient.NsclientPacket;
import org.opennms.protocols.nsclient.detector.client.NsclientClient;
import org.opennms.protocols.nsclient.detector.request.NsclientRequest;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class NsclientDetector
extends BasicDetector<NsclientRequest, NsclientPacket> {
    private static final String DEFAULT_SERVICE_NAME = "NSClient";
    private String command = NsclientManager.convertTypeToString("1");
    private String password = "None";
    private String parameter;
    private int warnPerc;
    private int critPerc;

    public NsclientDetector() {
        super(DEFAULT_SERVICE_NAME, 1248);
    }

    public NsclientDetector(String serviceName, int port) {
        super(serviceName, port);
    }

    protected void onInit() {
        this.send(this.getRequest(), this.getNsclientValidator());
    }

    private ClientConversation.ResponseValidator<NsclientPacket> getNsclientValidator() {
        return new ClientConversation.ResponseValidator<NsclientPacket>(){

            public boolean validate(NsclientPacket pack) {
                return pack != null && pack.getResultCode() != 2 && pack.getResultCode() != -1;
            }
        };
    }

    private NsclientRequest getRequest() {
        NsclientRequest request = new NsclientRequest();
        request.setCommand(this.getCommand());
        request.setParameter(this.getParameter());
        request.setWarnPerc(this.getWarnPerc());
        request.setCritPerc(this.getCritPerc());
        request.setRetries(this.getRetries());
        return request;
    }

    protected Client<NsclientRequest, NsclientPacket> getClient() {
        NsclientClient client = new NsclientClient();
        client.setPassword(this.getPassword());
        return client;
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getParameter() {
        return this.parameter;
    }

    public void setParameter(String parameter) {
        this.parameter = parameter;
    }

    public int getWarnPerc() {
        return this.warnPerc;
    }

    public void setWarnPerc(int warnPerc) {
        this.warnPerc = warnPerc;
    }

    public int getCritPerc() {
        return this.critPerc;
    }

    public void setCritPerc(int critPerc) {
        this.critPerc = critPerc;
    }
}

