/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dhcpd;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import org.dhcp4java.DHCPPacket;

public final class Message
implements Serializable {
    private static final long serialVersionUID = -2712181407338192347L;
    private DHCPPacket m_dhcpmsg;
    private InetAddress m_target;

    Message() {
        this.m_dhcpmsg = null;
        this.m_target = null;
    }

    public Message(InetAddress target, DHCPPacket msg) {
        this.m_dhcpmsg = msg;
        this.m_target = target;
    }

    public InetAddress getAddress() {
        return this.m_target;
    }

    public DHCPPacket getMessage() {
        return this.m_dhcpmsg;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.m_target);
        byte[] buf = this.m_dhcpmsg.serialize();
        out.writeInt(buf.length);
        out.write(buf);
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        this.m_target = (InetAddress)in.readObject();
        byte[] buf = new byte[in.readInt()];
        in.readFully(buf, 0, buf.length);
        this.m_dhcpmsg = DHCPPacket.getPacket((byte[])buf, (int)0, (int)buf.length, (boolean)true);
    }
}

