/*
 * Decompiled with CFR 0.152.
 */
package org.dhcp4java;

import java.net.DatagramPacket;
import org.dhcp4java.DHCPCoreServer;
import org.dhcp4java.DHCPServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DHCPServletDispatcher
implements Runnable {
    private static final Logger s_aLogger = LoggerFactory.getLogger(DHCPServletDispatcher.class);
    private final DHCPCoreServer m_aServer;
    private final DHCPServlet m_aDispatchServlet;
    private final DatagramPacket m_aDispatchPacket;

    public DHCPServletDispatcher(DHCPCoreServer dHCPCoreServer, DHCPServlet dHCPServlet, DatagramPacket datagramPacket) {
        this.m_aServer = dHCPCoreServer;
        this.m_aDispatchServlet = dHCPServlet;
        this.m_aDispatchPacket = datagramPacket;
    }

    @Override
    public void run() {
        try {
            DatagramPacket datagramPacket = this.m_aDispatchServlet.serviceDatagram(this.m_aDispatchPacket);
            this.m_aServer.sendResponse(datagramPacket);
        }
        catch (Exception exception) {
            s_aLogger.info("Exception in dispatcher", (Throwable)exception);
        }
    }
}

