/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.jdhcp;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.opennms.jdhcp.MalformedPacketException;

public class DHCPOptions {
    private Map<Byte, DHCPOptionsEntry> optionsTable = new ConcurrentHashMap<Byte, DHCPOptionsEntry>();

    public void removeOption(byte entryCode) {
        this.optionsTable.remove(entryCode);
    }

    public boolean contains(byte entryCode) {
        return this.optionsTable.containsKey(entryCode);
    }

    public boolean isEmpty() {
        return this.optionsTable.isEmpty();
    }

    public byte[] getOption(byte entryCode) {
        if (this.contains(entryCode)) {
            return this.optionsTable.get((Object)Byte.valueOf((byte)entryCode)).content;
        }
        return null;
    }

    public void setOption(byte entryCode, byte[] value) {
        this.optionsTable.put(entryCode, new DHCPOptionsEntry(entryCode, (byte)value.length, value));
    }

    private byte[] getArrayOption(int length, int position, byte[] options) throws MalformedPacketException {
        byte[] value = new byte[length];
        try {
            System.arraycopy(options, position, value, 0, length);
        }
        catch (Exception e) {
            throw new MalformedPacketException(e);
        }
        return value;
    }

    public void internalize(byte[] optionsArray) throws MalformedPacketException {
        byte length;
        for (int pos = 4; pos < optionsArray.length && optionsArray[pos] != -1; pos += length) {
            byte code = optionsArray[pos++];
            length = optionsArray[pos++];
            byte[] value = this.getArrayOption(length, pos, optionsArray);
            this.setOption(code, value);
        }
    }

    public byte[] externalize() {
        byte[] options = new byte[312];
        options[0] = 99;
        options[1] = -126;
        options[2] = 83;
        options[3] = 99;
        int position = 4;
        for (DHCPOptionsEntry entry : this.optionsTable.values()) {
            options[position++] = entry.code;
            options[position++] = entry.length;
            for (int i = 0; i < entry.length; ++i) {
                options[position++] = entry.content[i];
            }
        }
        options[position] = -1;
        return options;
    }

    public void printList() {
        System.out.println(this.optionsTable.toString());
    }

    private static class DHCPOptionsEntry {
        protected byte code;
        protected byte length;
        protected byte[] content;

        public DHCPOptionsEntry(byte entryCode, byte entryLength, byte[] entryContent) {
            this.code = entryCode;
            this.length = entryLength;
            this.content = entryContent;
        }
    }
}

