/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.dhcp.detector.client;

import java.io.IOException;
import java.net.InetAddress;
import org.opennms.netmgt.dhcpd.Dhcpd;
import org.opennms.netmgt.provision.support.Client;
import org.opennms.protocols.dhcp.detector.request.DhcpRequest;
import org.opennms.protocols.dhcp.detector.response.DhcpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DhcpClient
implements Client<DhcpRequest, DhcpResponse> {
    private static final Logger LOG = LoggerFactory.getLogger(DhcpClient.class);
    private int m_retries;
    private int m_timeout;
    private InetAddress m_address;

    public void close() {
    }

    public void connect(InetAddress address, int port, int timeout) throws IOException, Exception {
        this.m_address = address;
        this.m_timeout = timeout;
    }

    public DhcpResponse receiveBanner() throws IOException, Exception {
        long responseTime = Dhcpd.isServer(this.m_address, this.m_timeout, this.getRetries());
        LOG.debug("got a response from the server: {}", (Object)responseTime);
        return new DhcpResponse(responseTime);
    }

    public DhcpResponse sendRequest(DhcpRequest request) throws IOException, Exception {
        return null;
    }

    public void setRetries(int retries) {
        this.m_retries = retries;
    }

    public int getRetries() {
        return this.m_retries;
    }
}

