/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.dhcp.detector;

import org.opennms.netmgt.provision.support.BasicDetector;
import org.opennms.netmgt.provision.support.Client;
import org.opennms.netmgt.provision.support.ResponseValidator;
import org.opennms.protocols.dhcp.detector.client.DhcpClient;
import org.opennms.protocols.dhcp.detector.request.DhcpRequest;
import org.opennms.protocols.dhcp.detector.response.DhcpResponse;

public class DhcpDetector
extends BasicDetector<DhcpRequest, DhcpResponse> {
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 3000;

    public DhcpDetector() {
        super("DHCP", 0);
        this.setTimeout(3000);
        this.setRetries(0);
    }

    protected void onInit() {
        this.expectBanner(DhcpDetector.responseTimeGreaterThan(-1L));
    }

    private static ResponseValidator<DhcpResponse> responseTimeGreaterThan(final long num) {
        return new ResponseValidator<DhcpResponse>(){

            public boolean validate(DhcpResponse response) {
                return response.validate(num);
            }
        };
    }

    protected Client<DhcpRequest, DhcpResponse> getClient() {
        DhcpClient client = new DhcpClient();
        client.setRetries(1);
        return client;
    }
}

