/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.jdhcp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.opennms.jdhcp.DHCPOptions;
import org.opennms.jdhcp.MalformedPacketException;

public class DHCPMessage {
    private byte op;
    private byte htype;
    private byte hlen;
    private byte hops;
    private int xid;
    private short secs;
    private short flags;
    private byte[] ciaddr = new byte[4];
    private byte[] yiaddr = new byte[4];
    private byte[] siaddr = new byte[4];
    private byte[] giaddr = new byte[4];
    private byte[] chaddr = new byte[16];
    private byte[] sname = new byte[64];
    private byte[] file = new byte[128];
    private DHCPOptions optionsList = new DHCPOptions();
    private int gPort;
    private InetAddress destination;
    public static final int CLIENT_PORT = 68;
    public static final int SERVER_PORT = 67;
    public static final int DISCOVER = 1;
    public static final int OFFER = 2;
    public static final int REQUEST = 3;
    public static final int DECLINE = 4;
    public static final int ACK = 5;
    public static final int NAK = 6;
    public static final int RELEASE = 7;
    public static final int INFORM = 8;
    private static InetAddress sBROADCAST = null;

    public DHCPMessage() {
        this.destination = sBROADCAST;
        this.gPort = 67;
    }

    public DHCPMessage(DHCPMessage inMessage) throws MalformedPacketException {
        this.destination = sBROADCAST;
        this.gPort = 67;
        this.setMessageValues(inMessage);
        this.optionsList.internalize(inMessage.getOptions());
    }

    public DHCPMessage(DHCPMessage inMessage, InetAddress inServername, int inPort) throws MalformedPacketException {
        this.destination = inServername;
        this.gPort = inPort;
        this.setMessageValues(inMessage);
        this.optionsList.internalize(inMessage.getOptions());
    }

    public DHCPMessage(DHCPMessage inMessage, InetAddress inServername) throws MalformedPacketException {
        this.destination = inServername;
        this.gPort = 67;
        this.setMessageValues(inMessage);
        this.optionsList.internalize(inMessage.getOptions());
    }

    public DHCPMessage(InetAddress inServername, int inPort) {
        this.destination = inServername;
        this.gPort = inPort;
    }

    public DHCPMessage(InetAddress inServername) {
        this.destination = inServername;
        this.gPort = 67;
    }

    public DHCPMessage(int inPort) {
        this.destination = sBROADCAST;
        this.gPort = inPort;
    }

    public DHCPMessage(byte[] ibuf) throws MalformedPacketException {
        this.internalize(ibuf);
        this.destination = sBROADCAST;
        this.gPort = 67;
    }

    public DHCPMessage(byte[] ibuf, InetAddress inServername, int inPort) throws MalformedPacketException {
        this.internalize(ibuf);
        this.destination = inServername;
        this.gPort = inPort;
    }

    public DHCPMessage(byte[] ibuf, int inPort) throws MalformedPacketException {
        this.internalize(ibuf);
        this.destination = sBROADCAST;
        this.gPort = inPort;
    }

    public DHCPMessage(byte[] ibuf, InetAddress inServername) throws MalformedPacketException {
        this.internalize(ibuf);
        this.destination = inServername;
        this.gPort = 67;
    }

    public DHCPMessage(DataInputStream inStream) throws MalformedPacketException {
        this.readInputStream(inStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized byte[] externalize() throws IOException {
        ByteArrayOutputStream outBStream = null;
        DataOutputStream outStream = null;
        try {
            outBStream = new ByteArrayOutputStream();
            outStream = new DataOutputStream(outBStream);
            outStream.writeByte(this.op);
            outStream.writeByte(this.htype);
            outStream.writeByte(this.hlen);
            outStream.writeByte(this.hops);
            outStream.writeInt(this.xid);
            outStream.writeShort(this.secs);
            outStream.writeShort(this.flags);
            outStream.write(this.ciaddr, 0, 4);
            outStream.write(this.yiaddr, 0, 4);
            outStream.write(this.siaddr, 0, 4);
            outStream.write(this.giaddr, 0, 4);
            outStream.write(this.chaddr, 0, 16);
            outStream.write(this.sname, 0, 64);
            outStream.write(this.file, 0, 128);
            byte[] options = this.optionsList.externalize();
            outStream.write(options, 0, 312);
        }
        catch (Throwable throwable) {
            DHCPMessage.closeQuietly(outStream);
            DHCPMessage.closeQuietly(outBStream);
            throw throwable;
        }
        DHCPMessage.closeQuietly(outStream);
        DHCPMessage.closeQuietly(outBStream);
        return outBStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized DHCPMessage internalize(byte[] ibuff) throws MalformedPacketException {
        ByteArrayInputStream inBStream = null;
        DataInputStream inStream = null;
        try {
            inBStream = new ByteArrayInputStream(ibuff, 0, ibuff.length);
            inStream = new DataInputStream(inBStream);
            this.readInputStream(inStream);
        }
        catch (Throwable throwable) {
            DHCPMessage.closeQuietly(inStream);
            DHCPMessage.closeQuietly(inBStream);
            throw throwable;
        }
        DHCPMessage.closeQuietly(inStream);
        DHCPMessage.closeQuietly(inBStream);
        return this;
    }

    public void setOp(byte inOp) {
        this.op = inOp;
    }

    public void setHtype(byte inHtype) {
        this.htype = inHtype;
    }

    public void setHlen(byte inHlen) {
        this.hlen = inHlen;
    }

    public void setHops(byte inHops) {
        this.hops = inHops;
    }

    public void setXid(int inXid) {
        this.xid = inXid;
    }

    public void setSecs(short inSecs) {
        this.secs = inSecs;
    }

    public void setFlags(short inFlags) {
        this.flags = inFlags;
    }

    public void setCiaddr(byte[] inCiaddr) {
        this.ciaddr = inCiaddr;
    }

    public void setYiaddr(byte[] inYiaddr) {
        this.yiaddr = inYiaddr;
    }

    public void setSiaddr(byte[] inSiaddr) {
        this.siaddr = inSiaddr;
    }

    public void setGiaddr(byte[] inGiaddr) {
        this.giaddr = inGiaddr;
    }

    public void setChaddr(byte[] inChaddr) {
        this.chaddr = inChaddr;
    }

    public void setSname(byte[] inSname) {
        this.sname = inSname;
    }

    public void setFile(byte[] inFile) {
        this.file = inFile;
    }

    public void setPort(int inPortNum) {
        this.gPort = inPortNum;
    }

    public void setDestination(InetAddress addr) {
        this.destination = addr;
    }

    public byte getOp() {
        return this.op;
    }

    public byte getHtype() {
        return this.htype;
    }

    public byte getHlen() {
        return this.hlen;
    }

    public byte getHops() {
        return this.hops;
    }

    public int getXid() {
        return this.xid;
    }

    public short getSecs() {
        return this.secs;
    }

    public short getFlags() {
        return this.flags;
    }

    public byte[] getCiaddr() {
        return this.ciaddr;
    }

    public byte[] getYiaddr() {
        return this.yiaddr;
    }

    public byte[] getSiaddr() {
        return this.siaddr;
    }

    public byte[] getGiaddr() {
        return this.giaddr;
    }

    public byte[] getChaddr() {
        return this.chaddr;
    }

    public byte[] getSname() {
        return this.sname;
    }

    public byte[] getFile() {
        return this.file;
    }

    public byte[] getOptions() {
        return this.optionsList.externalize();
    }

    public int getPort() {
        return this.gPort;
    }

    public InetAddress getDestination() {
        return this.destination;
    }

    public void setOption(int inOptNum, byte[] inOptionData) {
        this.optionsList.setOption((byte)inOptNum, inOptionData);
    }

    public byte[] getOption(int inOptNum) {
        return this.optionsList.getOption((byte)inOptNum);
    }

    public void removeOption(int inOptNum) {
        this.optionsList.removeOption((byte)inOptNum);
    }

    public boolean isOptSet(int inOptNum) {
        return this.optionsList.contains((byte)inOptNum);
    }

    public void printMessage() throws IOException {
        byte[] data = this.externalize();
        for (int i = 0; i < 100; ++i) {
            System.out.print(data[i]);
            if (i % 25 == 0 && i != 0) {
                System.out.print("\n");
                continue;
            }
            System.out.print(" ");
        }
        System.out.print("\n");
        this.optionsList.printList();
    }

    private void setMessageValues(DHCPMessage inMessage) {
        this.op = inMessage.getOp();
        this.htype = inMessage.getHtype();
        this.hlen = inMessage.getHlen();
        this.hops = inMessage.getHops();
        this.xid = inMessage.getXid();
        this.secs = inMessage.getSecs();
        this.flags = inMessage.getFlags();
        this.ciaddr = inMessage.getCiaddr();
        this.yiaddr = inMessage.getYiaddr();
        this.siaddr = inMessage.getSiaddr();
        this.giaddr = inMessage.getGiaddr();
        this.chaddr = inMessage.getChaddr();
        this.sname = inMessage.getSname();
        this.file = inMessage.getFile();
    }

    private void readInputStream(DataInputStream inStream) throws MalformedPacketException {
        try {
            this.op = inStream.readByte();
            this.htype = inStream.readByte();
            this.hlen = inStream.readByte();
            this.hops = inStream.readByte();
            this.xid = inStream.readInt();
            this.secs = inStream.readShort();
            this.flags = inStream.readShort();
            inStream.readFully(this.ciaddr, 0, 4);
            inStream.readFully(this.yiaddr, 0, 4);
            inStream.readFully(this.siaddr, 0, 4);
            inStream.readFully(this.giaddr, 0, 4);
            inStream.readFully(this.chaddr, 0, 16);
            inStream.readFully(this.sname, 0, 64);
            inStream.readFully(this.file, 0, 128);
            byte[] options = new byte[312];
            inStream.readFully(options, 0, 312);
            this.optionsList.internalize(options);
        }
        catch (IOException e) {
            throw new MalformedPacketException("Unable to read packet stream.", e);
        }
    }

    private static void closeQuietly(OutputStream stream) {
        if (stream == null) {
            return;
        }
        try {
            stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void closeQuietly(InputStream stream) {
        if (stream == null) {
            return;
        }
        try {
            stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static {
        try {
            sBROADCAST = InetAddress.getByName("255.255.255.255");
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException(e);
        }
    }
}

