/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.dhcp.monitor;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Map;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.dhcpd.Dhcpd;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.DistributionContext;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.monitors.AbstractServiceMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Distributable(value={DistributionContext.DAEMON})
public final class DhcpMonitor
extends AbstractServiceMonitor {
    private static final Logger LOG = LoggerFactory.getLogger(DhcpMonitor.class);
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 3000;

    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        int retry = ParameterMap.getKeyedInteger(parameters, (String)"retry", (int)0);
        int timeout = ParameterMap.getKeyedInteger(parameters, (String)"timeout", (int)3000);
        InetAddress ipAddr = svc.getAddress();
        LOG.debug("DhcpMonitor.poll: address: {} timeout: {} retry: {}", new Object[]{ipAddr, timeout, retry});
        PollStatus serviceStatus = PollStatus.unavailable();
        long responseTime = -1L;
        try {
            responseTime = Dhcpd.isServer(ipAddr, timeout, retry);
            if (responseTime >= 0L) {
                serviceStatus = PollStatus.available((Double)Double.valueOf(responseTime));
            }
        }
        catch (IOException e) {
            e.fillInStackTrace();
            LOG.debug("An I/O exception occured during DHCP polling", (Throwable)e);
            serviceStatus = PollStatus.unavailable((String)"An I/O exception occured during DHCP polling");
        }
        catch (Throwable e) {
            e.fillInStackTrace();
            LOG.debug("An unexpected exception occured during DHCP polling", e);
            serviceStatus = PollStatus.unavailable((String)"An unexpected exception occured during DHCP polling");
        }
        return serviceStatus;
    }
}

