/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.dhcpd;

import java.io.File;
import java.io.IOException;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.config.dhcpd.DhcpdConfiguration;

public final class DhcpdConfigFactory {
    private static DhcpdConfigFactory m_singleton = null;
    private DhcpdConfiguration m_config;
    private static boolean m_loaded = false;

    DhcpdConfigFactory(File configFile) {
        this.m_config = (DhcpdConfiguration)JaxbUtils.unmarshal(DhcpdConfiguration.class, (File)configFile);
    }

    public static synchronized void init() throws IOException {
        if (m_loaded) {
            return;
        }
        File configFile = ConfigFileConstants.getFile((int)ConfigFileConstants.DHCPD_CONFIG_FILE_NAME);
        m_singleton = new DhcpdConfigFactory(configFile);
        m_loaded = true;
    }

    public static synchronized void reload() throws IOException {
        m_singleton = null;
        m_loaded = false;
        DhcpdConfigFactory.init();
    }

    public static synchronized DhcpdConfigFactory getInstance() {
        if (!m_loaded) {
            throw new IllegalStateException("The factory has not been initialized");
        }
        return m_singleton;
    }

    public synchronized int getPort() {
        return this.m_config.getPort();
    }

    public synchronized String getMacAddress() {
        return this.m_config.getMacAddress();
    }

    public synchronized String getMyIpAddress() {
        return this.m_config.getMyIpAddress();
    }

    public synchronized String getRequestIpAddress() {
        return this.m_config.getRequestIpAddress();
    }

    public synchronized String getExtendedMode() {
        return this.m_config.getExtendedMode();
    }
}

