/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dhcpd;

import edu.bucknell.net.JDHCP.DHCPMessage;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.BindException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.util.Iterator;
import java.util.List;
import org.opennms.core.fiber.Fiber;
import org.opennms.netmgt.dhcpd.Client;
import org.opennms.netmgt.dhcpd.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Receiver2
implements Runnable,
Fiber {
    private static final Logger LOG = LoggerFactory.getLogger(Receiver2.class);
    private static final short DHCP_TARGET_PORT = 67;
    private DatagramSocket m_receiver;
    private String m_name = "DHCPReceiver2";
    private int m_status = 0;
    private Thread m_worker = null;
    private List<Client> m_clients;

    Receiver2(List<Client> clients) throws IOException {
        try {
            this.m_receiver = new DatagramSocket(67);
        }
        catch (BindException e) {
            BindException newE = new BindException("Could not open datagram socket for DHCP client on port 67.  Is there another DHCP client listening on this port?  Original exception: " + e);
            newE.initCause(e);
            throw newE;
        }
        this.m_receiver.setSoTimeout(1000);
        this.m_clients = clients;
    }

    public synchronized void start() {
        if (this.m_worker != null) {
            throw new IllegalStateException("The fiber has already been started");
        }
        this.m_worker = new Thread((Runnable)this, this.getName());
        this.m_worker.setDaemon(true);
        this.m_worker.start();
        this.m_status = 1;
    }

    public synchronized void stop() {
        this.m_status = 3;
        this.m_receiver.close();
        this.m_worker.interrupt();
    }

    public synchronized int getStatus() {
        return this.m_status;
    }

    public String getName() {
        return this.m_name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Receiver2 receiver2;
        Receiver2 receiver22 = this;
        synchronized (receiver22) {
            this.m_status = 2;
        }
        byte[] dgbuf = new byte[2048];
        while (true) {
            Receiver2 receiver23;
            try {
                DatagramPacket pkt = new DatagramPacket(dgbuf, dgbuf.length);
                this.m_receiver.receive(pkt);
                LOG.debug("got a DHCP response.");
                Message msg = new Message(pkt.getAddress(), new DHCPMessage(pkt.getData()));
                List<Client> list = this.m_clients;
                synchronized (list) {
                    Iterator<Client> iter = this.m_clients.iterator();
                    if (!iter.hasNext()) {
                        LOG.debug("No client waiting for response.");
                    }
                    while (iter.hasNext()) {
                        Client c = iter.next();
                        if (c.getStatus() == 2) {
                            try {
                                LOG.debug("sending DHCP response pkt to client {}", (Object)c.getName());
                                c.sendMessage(msg);
                            }
                            catch (IOException ex) {
                                LOG.warn("Error sending response to client {}", (Object)c.getName());
                            }
                            continue;
                        }
                        if (c.getStatus() != 4) continue;
                        LOG.debug("Removing stale client {}", (Object)c.getName());
                        iter.remove();
                    }
                }
            }
            catch (InterruptedIOException pkt) {
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                LOG.warn("An error occurred when reading DHCP response. Ignoring exception: ", (Throwable)ex);
            }
            catch (NegativeArraySizeException ex) {
                LOG.warn("An error occurred when reading DHCP response. Ignoring exception: ", (Throwable)ex);
            }
            catch (IOException ex) {
                receiver23 = this;
                synchronized (receiver23) {
                    if (this.m_status == 2) {
                        LOG.warn("Failed to read message, I/O error", (Throwable)ex);
                    }
                    break;
                }
            }
            catch (Throwable t) {
                receiver23 = this;
                synchronized (receiver23) {
                    if (this.m_status == 2) {
                        LOG.warn("Undeclared throwable caught", t);
                    }
                    break;
                }
            }
            receiver2 = this;
            synchronized (receiver2) {
                if (this.m_status != 2) {
                    break;
                }
            }
        }
        receiver2 = this;
        synchronized (receiver2) {
            this.m_status = 3;
        }
        this.m_receiver.close();
        receiver2 = this;
        synchronized (receiver2) {
            this.m_status = 4;
        }
    }
}

