/*
 * Decompiled with CFR 0.152.
 */
package edu.bucknell.net.JDHCP;

import edu.bucknell.net.JDHCP.DHCPMessage;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;

public class DHCPSocket
extends DatagramSocket {
    protected static int PACKET_SIZE = 1500;
    private int defaultSOTIME_OUT = 3000;
    private DatagramSocket gSocket;

    public DHCPSocket(int n) throws SocketException {
        super(n);
        this.setSoTimeout(this.defaultSOTIME_OUT);
    }

    public void setMTU(int n) {
        PACKET_SIZE = n;
    }

    public int getMTU() {
        return PACKET_SIZE;
    }

    public synchronized void send(DHCPMessage dHCPMessage) throws IOException {
        byte[] byArray = new byte[PACKET_SIZE];
        byArray = dHCPMessage.externalize();
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(dHCPMessage.getDestinationAddress());
        }
        catch (UnknownHostException unknownHostException) {}
        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, inetAddress, dHCPMessage.getPort());
        this.send(datagramPacket);
    }

    public synchronized boolean receive(DHCPMessage dHCPMessage) {
        try {
            DatagramPacket datagramPacket = new DatagramPacket(new byte[PACKET_SIZE], PACKET_SIZE);
            this.receive(datagramPacket);
            dHCPMessage.internalize(datagramPacket.getData());
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }
}

