/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dhcpd;

import edu.bucknell.net.JDHCP.DHCPMessage;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Random;
import java.util.StringTokenizer;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.dhcpd.DhcpdConfigFactory;
import org.opennms.netmgt.dhcpd.Message;
import org.opennms.netmgt.utils.IpValidator;

final class Poller {
    private static final byte[] DEFAULT_MAC_ADDRESS = new byte[]{0, 6, 13, -66, -100, -78, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static byte[] s_hwAddress = null;
    private static byte[] s_myIpAddress = null;
    private static byte[] s_requestIpAddress = null;
    private static boolean reqTargetIp = true;
    private static boolean targetOffset = true;
    private static boolean relayMode = false;
    private static boolean paramsChecked = false;
    private static Boolean extendedMode = false;
    static final short BROADCAST_FLAG = Short.MIN_VALUE;
    static final int DEFAULT_RETRIES = 2;
    static final long DEFAULT_TIMEOUT = 3000L;
    private static final int MESSAGE_TYPE = 53;
    private static final int REQUESTED_IP = 50;
    private static int m_nextXid = new Random(System.currentTimeMillis()).nextInt();
    private Socket m_connection;
    private ObjectOutputStream m_outs;
    private ObjectInputStream m_ins;

    private static Message getDisconnectRequest() throws UnknownHostException {
        return new Message(InetAddressUtils.addr((String)"0.0.0.0"), new DHCPMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Message getPollingRequest(InetAddress addr, byte mType) {
        int xid = 0;
        Class<Poller> clazz = Poller.class;
        synchronized (Poller.class) {
            xid = ++m_nextXid;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            DHCPMessage messageOut = new DHCPMessage();
            byte[] rawIp = addr.getAddress();
            if (targetOffset) {
                rawIp[3] = rawIp[3] % 2 == 0 && rawIp[3] != 0 ? (byte)(rawIp[3] - 1) : (byte)(rawIp[3] + 1);
            }
            messageOut.setOp((byte)1);
            messageOut.setHtype((byte)1);
            messageOut.setHlen((byte)6);
            messageOut.setXid(xid);
            messageOut.setSecs((short)0);
            messageOut.setChaddr(s_hwAddress);
            if (relayMode) {
                messageOut.setHops((byte)1);
                messageOut.setGiaddr(s_myIpAddress);
            } else {
                messageOut.setHops((byte)0);
                messageOut.setFlags((short)Short.MIN_VALUE);
            }
            messageOut.setOption(53, new byte[]{mType});
            if (mType == 3) {
                if (reqTargetIp) {
                    messageOut.setOption(50, rawIp);
                    messageOut.setCiaddr(rawIp);
                } else {
                    messageOut.setOption(50, s_requestIpAddress);
                    messageOut.setCiaddr(s_requestIpAddress);
                }
            }
            if (mType == 8) {
                messageOut.setOption(50, s_myIpAddress);
                messageOut.setCiaddr(s_myIpAddress);
            }
            return new Message(addr, messageOut);
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    private Poller(long timeout) throws IOException {
        ThreadCategory log = ThreadCategory.getInstance(this.getClass());
        DhcpdConfigFactory dcf = DhcpdConfigFactory.getInstance();
        try {
            if (log.isDebugEnabled()) {
                log.debug("Poller.ctor: opening socket connection with DHCP client daemon on port " + dcf.getPort());
            }
            this.m_connection = new Socket(InetAddressUtils.addr((String)"127.0.0.1"), dcf.getPort());
            if (log.isDebugEnabled()) {
                log.debug("Poller.ctor: setting socket timeout to " + timeout);
            }
            this.m_connection.setSoTimeout((int)timeout);
            this.m_ins = new ObjectInputStream(this.m_connection.getInputStream());
            this.m_outs = new ObjectOutputStream(this.m_connection.getOutputStream());
            this.m_outs.reset();
            this.m_outs.flush();
        }
        catch (IOException ex) {
            log.error("IO Exception during socket connection establishment with DHCP client daemon.", (Throwable)ex);
            if (this.m_connection != null) {
                try {
                    this.m_ins.close();
                    this.m_outs.close();
                    this.m_connection.close();
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            throw ex;
        }
        catch (Throwable t) {
            log.error("Unexpected exception during socket connection establishment with DHCP client daemon.", t);
            if (this.m_connection != null) {
                try {
                    this.m_ins.close();
                    this.m_outs.close();
                    this.m_connection.close();
                }
                catch (Throwable tx) {
                    // empty catch block
                }
            }
            throw new UndeclaredThrowableException(t);
        }
    }

    public void close() {
        ThreadCategory log = ThreadCategory.getInstance(Poller.class);
        try {
            if (log.isDebugEnabled()) {
                log.debug("Closing connection");
            }
            this.m_ins.close();
            this.m_outs.close();
            this.m_connection.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static long isServer(InetAddress host, long timeout, int retries) throws IOException {
        ThreadCategory log = ThreadCategory.getInstance(Poller.class);
        boolean isDhcpServer = false;
        byte[] typeList = new byte[]{1, 8, 3};
        String[] typeName = new String[]{"DISCOVER", "INFORM", "REQUEST"};
        DhcpdConfigFactory dcf = DhcpdConfigFactory.getInstance();
        if (!paramsChecked) {
            String s_extendedMode = dcf.getExtendedMode();
            extendedMode = s_extendedMode == null ? Boolean.valueOf(false) : Boolean.valueOf(Boolean.parseBoolean(s_extendedMode));
            if (log.isDebugEnabled()) {
                log.debug("isServer: DHCP extended mode is " + extendedMode);
            }
            String hwAddressStr = dcf.getMacAddress();
            if (log.isDebugEnabled()) {
                log.debug("isServer: DHCP query hardware/MAC address is " + hwAddressStr);
            }
            Poller.setHwAddress(hwAddressStr);
            String myIpStr = dcf.getMyIpAddress();
            if (log.isDebugEnabled()) {
                log.debug("isServer: DHCP relay agent address is " + myIpStr);
            }
            if (myIpStr != null && !myIpStr.equals("") && !myIpStr.equalsIgnoreCase("broadcast") && IpValidator.isIpValid((String)myIpStr)) {
                s_myIpAddress = Poller.setIpAddress(myIpStr);
                relayMode = true;
            }
            if (extendedMode.booleanValue()) {
                String requestStr = dcf.getRequestIpAddress();
                if (log.isDebugEnabled()) {
                    log.debug("isServer: REQUEST query target is " + requestStr);
                }
                if (requestStr != null && !requestStr.equals("") && !requestStr.equalsIgnoreCase("targetSubnet")) {
                    if (requestStr.equalsIgnoreCase("targetHost")) {
                        targetOffset = false;
                    } else if (IpValidator.isIpValid((String)requestStr)) {
                        s_requestIpAddress = Poller.setIpAddress(requestStr);
                        reqTargetIp = false;
                        targetOffset = false;
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug("REQUEST query options are: reqTargetIp = " + reqTargetIp + ", targetOffset = " + targetOffset);
                }
            }
            paramsChecked = true;
        }
        int j = 1;
        if (extendedMode.booleanValue()) {
            j = typeList.length;
        }
        if (timeout < 500L) {
            timeout = 500L;
        }
        Poller p = new Poller(timeout);
        long responseTime = -1L;
        try {
            block5: for (int i = 0; i < j; ++i) {
                Message ping = Poller.getPollingRequest(host, typeList[i]);
                for (int rt = retries; rt >= 0 && !isDhcpServer; --rt) {
                    long end;
                    if (log.isDebugEnabled()) {
                        log.debug("isServer: sending DHCP " + typeName[i] + " query to host " + InetAddressUtils.str((InetAddress)host) + " with Xid: " + ping.getMessage().getXid());
                    }
                    long start = System.currentTimeMillis();
                    p.m_outs.writeObject(ping);
                    do {
                        Message resp = null;
                        try {
                            resp = (Message)p.m_ins.readObject();
                        }
                        catch (InterruptedIOException ex) {
                            resp = null;
                        }
                        if (resp == null) continue;
                        responseTime = System.currentTimeMillis() - start;
                        if (log.isDebugEnabled()) {
                            log.debug("isServer: got a DHCP response from host " + InetAddressUtils.str((InetAddress)resp.getAddress()) + " with Xid: " + resp.getMessage().getXid());
                        }
                        if (!host.equals(resp.getAddress()) || ping.getMessage().getXid() != resp.getMessage().getXid()) continue;
                        byte[] type = resp.getMessage().getOption(53);
                        if (log.isDebugEnabled()) {
                            if (type[0] == 2) {
                                log.debug("isServer: got a DHCP OFFER response, validating...");
                            } else if (type[0] == 5) {
                                log.debug("isServer: got a DHCP ACK response, validating...");
                            } else if (type[0] == 6) {
                                log.debug("isServer: got a DHCP NAK response, validating...");
                            }
                        }
                        if (type[0] != 2 && (!extendedMode.booleanValue() || type[0] != 5 && type[0] != 6)) continue;
                        if (log.isDebugEnabled()) {
                            log.debug("isServer: got a valid DHCP response. responseTime= " + responseTime + "ms");
                        }
                        isDhcpServer = true;
                        break block5;
                    } while ((end = System.currentTimeMillis()) - start < timeout);
                    if (!log.isDebugEnabled() || isDhcpServer) continue;
                    log.debug("Timed out waiting for DHCP response, remaining retries: " + rt);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("Sending disconnect request");
            }
            p.m_outs.writeObject(Poller.getDisconnectRequest());
            if (log.isDebugEnabled()) {
                log.debug("wait half a sec before closing connection");
            }
            Thread.sleep(500L);
            p.close();
        }
        catch (IOException ex) {
            log.error("IO Exception caught.", (Throwable)ex);
            p.close();
            throw ex;
        }
        catch (Throwable t) {
            log.error("Unexpected Exception caught.", t);
            p.close();
            throw new UndeclaredThrowableException(t);
        }
        if (isDhcpServer) {
            return responseTime;
        }
        return -1L;
    }

    private static void setHwAddress(String hwAddressStr) {
        ThreadCategory log = ThreadCategory.getInstance(Poller.class);
        s_hwAddress = DEFAULT_MAC_ADDRESS;
        StringTokenizer token = new StringTokenizer(hwAddressStr, ":");
        if (token.countTokens() != 6 && log.isDebugEnabled()) {
            log.debug("Invalid format for hwAddress " + hwAddressStr);
        }
        int i = 0;
        while (i < 6) {
            try {
                int temp = Integer.parseInt(token.nextToken(), 16);
                Poller.s_hwAddress[i] = (byte)temp;
                ++i;
            }
            catch (NumberFormatException ex) {
                if (!log.isDebugEnabled()) continue;
                log.debug("Invalid format for hwAddress, " + ex);
            }
        }
    }

    private static byte[] setIpAddress(String ipAddressStr) {
        byte[] ipAddress = new byte[4];
        StringTokenizer token = new StringTokenizer(ipAddressStr, ".");
        for (int i = 0; i < 4; ++i) {
            int temp = Integer.parseInt(token.nextToken(), 10);
            ipAddress[i] = (byte)temp;
        }
        return ipAddress;
    }
}

