/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dhcpd;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.apache.log4j.Category;
import org.apache.log4j.Logger;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.dhcpd.DhcpdConfigFactory;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;
import org.opennms.netmgt.dhcpd.Client;
import org.opennms.netmgt.dhcpd.Poller;
import org.opennms.netmgt.dhcpd.Receiver;
import org.opennms.netmgt.dhcpd.Receiver2;
import org.opennms.netmgt.utils.IpValidator;

public final class Dhcpd
extends AbstractServiceDaemon
implements Runnable,
Observer {
    private static final Dhcpd m_singleton = new Dhcpd();
    private static List<Client> m_clients;
    private ServerSocket m_server;
    private Receiver m_listener;
    private Receiver2 m_listener2;
    private Thread m_worker;

    private Dhcpd() {
        super("OpenNMS.Dhcpd");
        m_clients = null;
        this.m_server = null;
        this.m_listener = null;
        this.m_listener2 = null;
        this.m_worker = null;
    }

    protected void onStart() {
        boolean relayMode = false;
        this.log().debug("start: DHCP client daemon starting...");
        if (this.m_worker != null && this.m_worker.isAlive()) {
            throw new IllegalStateException("The server is already running");
        }
        if (this.m_worker != null) {
            this.stop();
        }
        m_clients = Collections.synchronizedList(new LinkedList());
        DhcpdConfigFactory dFactory = null;
        try {
            DhcpdConfigFactory.reload();
            dFactory = DhcpdConfigFactory.getInstance();
        }
        catch (Exception ex) {
            this.log().error("Failed to load dhcpd configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        try {
            if (this.log().isDebugEnabled()) {
                this.log().debug("start: listening on TCP port " + dFactory.getPort() + " for incoming client requests.");
            }
            this.m_server = new ServerSocket(dFactory.getPort(), 0, InetAddressUtils.addr((String)"127.0.0.1"));
        }
        catch (IOException ex) {
            if (ex instanceof BindException) {
                this.managerLog().error((Object)"Failed to listen on DHCP port, perhaps something else is already listening?", (Throwable)ex);
                this.log().error("Failed to listen on DHCP port, perhaps something else is already listening?", (Throwable)ex);
            } else {
                this.log().error("Failed to initialize DHCP socket", (Throwable)ex);
            }
            throw new UndeclaredThrowableException(ex);
        }
        String myIpStr = DhcpdConfigFactory.getInstance().getMyIpAddress();
        if (this.log().isDebugEnabled()) {
            this.log().debug("Checking string \"" + myIpStr + "\" to see if we have an IP address");
        }
        if (myIpStr != null && !myIpStr.equals("") && !myIpStr.equalsIgnoreCase("broadcast") && IpValidator.isIpValid((String)myIpStr)) {
            relayMode = true;
        }
        if (this.log().isDebugEnabled()) {
            this.log().debug("Setting relay mode " + relayMode);
        }
        if (!relayMode || dFactory.getExtendedMode() != null && dFactory.getExtendedMode().equalsIgnoreCase("true")) {
            try {
                this.log().debug("start: starting receiver thread for port 68");
                this.m_listener = new Receiver(m_clients);
                this.m_listener.start();
            }
            catch (IOException ex) {
                try {
                    this.m_server.close();
                }
                catch (IOException ex1) {
                    // empty catch block
                }
                throw new UndeclaredThrowableException(ex);
            }
        }
        if (relayMode) {
            try {
                this.log().debug("start: starting receiver thread for port 67");
                this.m_listener2 = new Receiver2(m_clients);
                this.m_listener2.start();
            }
            catch (IOException ex) {
                try {
                    this.m_server.close();
                }
                catch (IOException ex1) {
                    // empty catch block
                }
                throw new UndeclaredThrowableException(ex);
            }
        }
        this.m_worker = new Thread((Runnable)this, this.getName());
        this.m_worker.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onStop() {
        if (this.m_worker == null) {
            return;
        }
        if (this.m_listener != null) {
            this.m_listener.stop();
        }
        if (this.m_listener2 != null) {
            this.m_listener2.stop();
        }
        try {
            this.m_server.close();
        }
        catch (IOException ex) {
            // empty catch block
        }
        Object[] list = null;
        List<Client> list2 = m_clients;
        synchronized (list2) {
            list = m_clients.toArray();
        }
        for (int x = 0; list != null && x < list.length; ++x) {
            ((Client)list[x]).stop();
        }
        this.m_server = null;
        m_clients = null;
        this.m_worker = null;
        this.m_listener = null;
        this.m_listener2 = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.waitForStatus(2);
        }
        catch (InterruptedException e1) {
            // empty catch block
        }
        this.log().debug("run: DHCPD client daemon running...");
        try {
            this.m_server.setSoTimeout(1000);
            while (true) {
                Socket sock;
                Dhcpd e1 = this;
                synchronized (e1) {
                    if (this.isPaused()) {
                        try {
                            this.waitForStatus(2);
                        }
                        catch (InterruptedException e) {}
                    } else if (!this.isRunning()) {
                        break;
                    }
                }
                try {
                    sock = this.m_server.accept();
                }
                catch (InterruptedIOException iE) {
                    continue;
                }
                this.log().debug("run: got connection request...creating client handler...");
                try {
                    Client clnt = new Client(sock);
                    m_clients.add(clnt);
                    clnt.addObserver(this);
                    clnt.start();
                }
                catch (IOException ioE) {
                    this.log().error("I/O exception occured creating client handler.", (Throwable)ioE);
                }
            }
        }
        catch (IOException ioE) {
            this.log().error("I/O exception occured processing incomming request", (Throwable)ioE);
        }
        catch (Throwable t) {
            this.log().error("An undeclared throwable was caught", t);
        }
        finally {
            this.log().debug("run: DHCPD client daemon run completed setting status to stopped");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Observable inst, Object ignored) {
        Dhcpd dhcpd = this;
        synchronized (dhcpd) {
            if (m_clients != null) {
                m_clients.remove(inst);
            }
        }
    }

    public static Dhcpd getInstance() {
        return m_singleton;
    }

    public static long isServer(InetAddress address, long timeout, int retries) throws IOException {
        return Poller.isServer(address, timeout, retries);
    }

    public static long isServer(InetAddress address) throws IOException {
        return Poller.isServer(address, 3000L, 2);
    }

    protected void onInit() {
    }

    private Category managerLog() {
        return Logger.getLogger((String)"OpenNMS.Manager");
    }
}

