/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.net.MalformedURLException;
import java.util.Map;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.SmbException;
import jcifs.smb.SmbFile;
import jcifs.smb.SmbFilenameFilter;
import org.opennms.core.utils.TimeoutTracker;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.monitors.support.ParameterSubstitutingMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCifsMonitor
extends ParameterSubstitutingMonitor {
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 3000;
    private static String modeCandidates = "";
    private final Logger logger = LoggerFactory.getLogger(JCifsMonitor.class);

    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        String folderIgnoreFiles;
        String domain = JCifsMonitor.resolveKeyedString(parameters, (String)"domain", (String)"");
        String username = JCifsMonitor.resolveKeyedString(parameters, (String)"username", (String)"");
        String password = JCifsMonitor.resolveKeyedString(parameters, (String)"password", (String)"");
        String mode = parameters.containsKey("mode") ? ((String)parameters.get("mode")).toUpperCase() : "PATH_EXIST";
        String path = parameters.containsKey("path") ? (String)parameters.get("path") : "";
        String smbHost = parameters.containsKey("smbHost") ? (String)parameters.get("smbHost") : "";
        String string = folderIgnoreFiles = parameters.containsKey("folderIgnoreFiles") ? (String)parameters.get("folderIgnoreFiles") : "";
        if ("".equals(smbHost)) {
            smbHost = svc.getIpAddr();
        }
        SmbFilenameFilter smbFilenameFilter = new SmbFilenameFilter(){

            public boolean accept(SmbFile smbFile, String s) throws SmbException {
                return !s.matches(folderIgnoreFiles);
            }
        };
        Mode enumMode = Mode.PATH_EXIST;
        try {
            enumMode = Mode.valueOf(mode);
        }
        catch (IllegalArgumentException exception) {
            this.logger.error("Mode '{}\u2018 does not exists. Valid candidates are {}", (Object)mode, (Object)modeCandidates);
            return PollStatus.unknown((String)("Mode " + mode + " does not exists. Valid candidates are " + modeCandidates));
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
            this.logger.debug("Added leading / to path.");
        }
        String authString = "";
        if (domain != null && !"".equals(domain)) {
            authString = authString + domain + ";";
        }
        authString = authString + username + ":" + password;
        String fullUrl = "smb://" + smbHost + path;
        this.logger.debug("Domain: [{}], Username: [{}], Password: [{}], Mode: [{}], Path: [{}], Authentication: [{}], Full Url: [{}]", new Object[]{domain, username, password, mode, path, authString, fullUrl});
        TimeoutTracker tracker = new TimeoutTracker(parameters, 0, 3000);
        PollStatus serviceStatus = PollStatus.unknown();
        tracker.reset();
        while (tracker.shouldRetry() && !serviceStatus.isAvailable()) {
            NtlmPasswordAuthentication ntlmPasswordAuthentication = new NtlmPasswordAuthentication(authString);
            try {
                SmbFile smbFile = new SmbFile(fullUrl, ntlmPasswordAuthentication);
                smbFile.setConnectTimeout(tracker.getConnectionTimeout());
                boolean smbFileExists = smbFile.exists();
                switch (enumMode) {
                    case PATH_EXIST: {
                        if (smbFileExists) {
                            serviceStatus = PollStatus.up();
                            break;
                        }
                        serviceStatus = PollStatus.down((String)("File " + fullUrl + " should exists but doesn't!"));
                        break;
                    }
                    case PATH_NOT_EXIST: {
                        if (!smbFileExists) {
                            serviceStatus = PollStatus.up();
                            break;
                        }
                        serviceStatus = PollStatus.down((String)("File " + fullUrl + " should not exists but does!"));
                        break;
                    }
                    case FOLDER_EMPTY: {
                        if (smbFileExists) {
                            if (smbFile.list(smbFilenameFilter).length == 0) {
                                serviceStatus = PollStatus.up();
                                break;
                            }
                            serviceStatus = PollStatus.down((String)("Directory " + fullUrl + " should be empty but isn't!"));
                            break;
                        }
                        serviceStatus = PollStatus.down((String)("Directory " + fullUrl + " should exists but doesn't!"));
                        break;
                    }
                    case FOLDER_NOT_EMPTY: {
                        if (smbFileExists) {
                            if (smbFile.list(smbFilenameFilter).length > 0) {
                                serviceStatus = PollStatus.up();
                                break;
                            }
                            serviceStatus = PollStatus.down((String)("Directory " + fullUrl + " should not be empty but is!"));
                            break;
                        }
                        serviceStatus = PollStatus.down((String)("Directory " + fullUrl + " should exists but doesn't!"));
                        break;
                    }
                    default: {
                        this.logger.warn("There is no implementation for the specified mode '{}'", (Object)mode);
                        break;
                    }
                }
            }
            catch (MalformedURLException exception) {
                this.logger.error("Malformed URL on '{}' with error: '{}'", (Object)smbHost, (Object)exception.getMessage());
                serviceStatus = PollStatus.down((String)exception.getMessage());
            }
            catch (SmbException exception) {
                this.logger.error("SMB error on '{}' with error: '{}'", (Object)smbHost, (Object)exception.getMessage());
                serviceStatus = PollStatus.down((String)exception.getMessage());
            }
            tracker.nextAttempt();
        }
        return serviceStatus;
    }

    static {
        for (Mode m : Mode.values()) {
            if (!"".equals(modeCandidates)) {
                modeCandidates = modeCandidates + ", ";
            }
            modeCandidates = modeCandidates + (Object)((Object)m);
        }
    }

    private static enum Mode {
        PATH_EXIST,
        PATH_NOT_EXIST,
        FOLDER_EMPTY,
        FOLDER_NOT_EMPTY;

    }
}

