/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.pluginmgr.vaadin.config.opennms;

import com.vaadin.annotations.Theme;
import com.vaadin.annotations.Title;
import com.vaadin.server.ExternalResource;
import com.vaadin.server.Page;
import com.vaadin.server.Resource;
import com.vaadin.server.VaadinRequest;
import com.vaadin.server.VaadinServletRequest;
import com.vaadin.shared.ui.label.ContentMode;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Component;
import com.vaadin.ui.CustomLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Link;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.opennms.features.pluginmgr.SessionPluginManager;
import org.opennms.features.pluginmgr.vaadin.pluginmanager.PluginManagerUIMainPanel;
import org.opennms.web.api.OnmsHeaderProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Theme(value="opennms")
@Title(value="Plugin Manager Administration")
public class PluginManagerAdminApplication
extends UI {
    private static final Logger LOG = LoggerFactory.getLogger(PluginManagerAdminApplication.class);
    private Map<String, String> headerLinks;
    private OnmsHeaderProvider m_headerProvider;
    private String m_headerHtml;
    private VerticalLayout m_rootLayout;
    private SessionPluginManager sessionPluginManager;

    public SessionPluginManager getSessionPluginManager() {
        return this.sessionPluginManager;
    }

    public void setSessionPluginManager(SessionPluginManager sessionPluginManager) {
        this.sessionPluginManager = sessionPluginManager;
    }

    public Map<String, String> getHeaderLinks() {
        return this.headerLinks;
    }

    public void setHeaderLinks(Map<String, String> headerLinks) {
        this.headerLinks = headerLinks;
    }

    public OnmsHeaderProvider getHeaderProvider() {
        return this.m_headerProvider;
    }

    public void setHeaderProvider(OnmsHeaderProvider headerProvider) {
        this.m_headerProvider = headerProvider;
    }

    public void setHeaderHtml(String headerHtml) {
        this.m_headerHtml = headerHtml;
    }

    private void addHeader(VaadinRequest request) {
        if (this.m_headerProvider != null) {
            try {
                this.setHeaderHtml(this.m_headerProvider.getHeaderHtml(((VaadinServletRequest)request).getHttpServletRequest()));
            }
            catch (Exception e) {
                LOG.error("failed to get header HTML for request " + request.getPathInfo(), e.getCause());
            }
        }
        if (this.m_headerHtml != null) {
            ByteArrayInputStream is = null;
            try {
                is = new ByteArrayInputStream(this.m_headerHtml.getBytes());
                CustomLayout headerLayout = new CustomLayout((InputStream)is);
                headerLayout.setWidth("100%");
                headerLayout.addStyleName("onmsheader");
                this.m_rootLayout.addComponent((Component)headerLayout);
            }
            catch (IOException e) {
                this.closeQuietly(is);
                LOG.debug("failed to get header layout data", (Throwable)e);
            }
        }
    }

    private void closeQuietly(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException closeE) {
                LOG.debug("failed to close HTML input stream", (Throwable)closeE);
            }
        }
    }

    public void init(VaadinRequest request) {
        this.m_rootLayout = new VerticalLayout();
        this.m_rootLayout.setSizeFull();
        this.m_rootLayout.addStyleName("root-layout");
        this.setContent((Component)this.m_rootLayout);
        Page.Styles styles = Page.getCurrent().getStyles();
        styles.add(".v-app .v-textfield-readonly {border: 1px solid #b6b6b6!important; border-top-color: #9d9d9d!important;border-bottom-color: #d6d6d6!important;border-right-color: #d6d6d6!important; opacity: 1.0!important;filter: none;  }");
        styles.add(".v-app .v-textarea-readonly {border: 1px solid #b6b6b6!important; border-top-color: #9d9d9d!important;border-bottom-color: #d6d6d6!important;border-right-color: #d6d6d6!important; opacity: 1.0!important;filter: none;  }");
        this.addHeader(request);
        if (this.headerLinks != null) {
            HorizontalLayout horizontalLayout1 = new HorizontalLayout();
            horizontalLayout1.setWidth("100%");
            horizontalLayout1.setDefaultComponentAlignment(Alignment.TOP_RIGHT);
            HorizontalLayout horizontalLayout2 = new HorizontalLayout();
            horizontalLayout1.addComponent((Component)horizontalLayout2);
            for (String name : this.headerLinks.keySet()) {
                String urlStr = this.headerLinks.get(name);
                ExternalResource urlResource = new ExternalResource(urlStr);
                Link link = new Link(name, (Resource)urlResource);
                Label label = new Label("&nbsp;&nbsp;&nbsp;", ContentMode.HTML);
                horizontalLayout2.addComponent((Component)link);
                horizontalLayout2.addComponent((Component)label);
            }
            this.m_rootLayout.addComponent((Component)horizontalLayout1);
        }
        PluginManagerUIMainPanel pluginManagerUIMainPanel = new PluginManagerUIMainPanel(this.sessionPluginManager);
        this.m_rootLayout.addComponent((Component)pluginManagerUIMainPanel);
        this.m_rootLayout.setExpandRatio((Component)pluginManagerUIMainPanel, 1.0f);
    }
}

