/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.karaf.productreg.cmd;

import java.util.Map;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.opennms.karaf.licencemgr.metadata.jaxb.ProductMetadata;
import org.opennms.karaf.productpub.ProductRegister;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(scope="product-reg", name="list", description="Lists product specifications installed in product registry")
public class ListRegProductSpecsCommand
extends OsgiCommandSupport {
    private static final Logger LOG = LoggerFactory.getLogger(ListRegProductSpecsCommand.class);
    private ProductRegister productRegister;

    public ProductRegister getProductRegister() {
        return this.productRegister;
    }

    public void setProductRegister(ProductRegister productRegister) {
        this.productRegister = productRegister;
    }

    protected Object doExecute() throws Exception {
        try {
            LOG.info("list of product specifications");
            Map<String, ProductMetadata> productSpecMap = this.getProductRegister().getProductDescriptionMap();
            for (Map.Entry<String, ProductMetadata> entry : productSpecMap.entrySet()) {
                ProductMetadata productSpecification = entry.getValue();
                String msg = "***********\n  productId='" + entry.getKey() + "'\n  productMetadata='" + productSpecification.toXml() + "'\n";
                System.out.println(msg);
                LOG.info(msg);
            }
            LOG.info("***********\n");
        }
        catch (Exception e) {
            System.err.println("Error getting list of installed licence specifications. Exception=" + e);
            LOG.error("Error getting list of installed licence specifications. Exception=", (Throwable)e);
        }
        return null;
    }
}

