/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.karaf.productpub.cmd;

import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.opennms.karaf.licencemgr.metadata.jaxb.ProductMetadata;
import org.opennms.karaf.productpub.ProductPublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(scope="product-pub", name="addproductspec", description="Adds product spec to product publisher for productId")
public class AddProductSpecCommand
extends OsgiCommandSupport {
    private static final Logger LOG = LoggerFactory.getLogger(AddProductSpecCommand.class);
    private ProductPublisher productPublisher;
    @Argument(index=0, name="productMetadata", description="product metadata as xml (surround xml in 'quotes') ", required=true, multiValued=false)
    String productMetadataXml = null;

    public ProductPublisher getProductPublisher() {
        return this.productPublisher;
    }

    public void setProductPublisher(ProductPublisher productPublisher) {
        this.productPublisher = productPublisher;
    }

    protected Object doExecute() throws Exception {
        try {
            ProductMetadata pmeta = new ProductMetadata();
            pmeta.fromXml(this.productMetadataXml);
            this.getProductPublisher().addProductDescription(pmeta);
            System.out.println("Added Product Metadata for productId='" + pmeta.getProductId() + "' productMetadata='" + pmeta.toXml() + "'");
            LOG.error("Added Product Metadata for productId='" + pmeta.getProductId() + "' productMetadata='" + pmeta.toXml() + "'");
        }
        catch (Exception e) {
            System.err.println("Error adding product spec for productId. Exception=" + e);
            LOG.error("Error adding product spec for productId. Exception=", (Throwable)e);
        }
        return null;
    }
}

