/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.karaf.productpub;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Scanner;
import org.opennms.karaf.licencemgr.metadata.jaxb.ProductMetadata;
import org.opennms.karaf.licencemgr.metadata.jaxb.ProductSpecList;
import org.opennms.karaf.productpub.BundleProductSpec;
import org.opennms.karaf.productpub.ProductPublisher;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleProductSpecImpl
implements BundleProductSpec {
    private static final Logger LOG = LoggerFactory.getLogger(BundleProductSpecImpl.class);
    private BundleContext bundleContext;
    private ProductMetadata productMetadata = null;
    private ProductPublisher productPublisher = null;
    private String productMetadataUri = null;
    private String productSpecListUri = null;
    private ProductSpecList productSpecList = null;

    private String readFile(InputStream is) {
        String str = null;
        try (Scanner s = null;){
            s = new Scanner(is, "UTF-8").useDelimiter("\\A");
            str = s.hasNext() ? s.next() : "";
        }
        return str;
    }

    @Override
    public void registerSpec() {
        if (this.productPublisher == null) {
            throw new RuntimeException("productPublisher cannot be null");
        }
        if (this.bundleContext == null) {
            throw new RuntimeException("bundleContext cannot be null");
        }
        if (this.productMetadata == null) {
            if (this.productMetadataUri == null) {
                throw new RuntimeException("productMetadataUri cannot be null if no productMetadata defined");
            }
            InputStream is = null;
            try {
                Bundle bundle = this.bundleContext.getBundle();
                is = bundle.getEntry(this.productMetadataUri).openStream();
                String productMetadataXml = this.readFile(is);
                this.productMetadata = new ProductMetadata();
                this.productMetadata.fromXml(productMetadataXml);
            }
            catch (Exception e) {
                throw new RuntimeException("cannot load productMetadata file from bundle productMetadataUri=" + this.productMetadataUri + "  " + e);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
                is = null;
            }
        }
        this.productPublisher.addProductDescription(this.productMetadata);
        System.out.println("Registered Product Specification for productId=" + this.productMetadata.getProductId());
        LOG.info("Registered Product Specification for productId=" + this.productMetadata.getProductId());
    }

    @Override
    public void unregisterSpec() {
        if (this.productPublisher != null) {
            try {
                this.productPublisher.removeProductDescription(this.productMetadata.getProductId());
                System.out.println("Unregistered Product Specification for productId=" + this.productMetadata.getProductId());
                LOG.info("Unregistered Product Specification for productId=" + this.productMetadata.getProductId());
            }
            catch (Exception e) {
                System.err.println("Problem Unregistering Product Specification for productId=" + this.productMetadata.getProductId() + "  " + e);
                LOG.error("Problem Unregistering Product Specification for productId=" + this.productMetadata.getProductId() + "  ", (Throwable)e);
            }
            finally {
                this.productPublisher = null;
            }
        }
    }

    @Override
    public void registerSpecificationList() {
        if (this.productPublisher == null) {
            throw new RuntimeException("productPublisher cannot be null");
        }
        if (this.bundleContext == null) {
            throw new RuntimeException("bundleContext cannot be null");
        }
        if (this.productSpecList == null) {
            if (this.productSpecListUri == null) {
                throw new RuntimeException("registerSpecificationList: productSpecListUri cannot be null if no productSpecList defined");
            }
            InputStream is = null;
            try {
                Bundle bundle = this.bundleContext.getBundle();
                is = bundle.getEntry(this.productSpecListUri).openStream();
                String productSpecListXml = this.readFile(is);
                this.productSpecList = new ProductSpecList();
                this.productSpecList.fromXml(productSpecListXml);
            }
            catch (Exception e) {
                throw new RuntimeException("registerSpecificationList: cannot load productSpecList file from bundle productSpecListUri=" + this.productSpecListUri + "  " + e);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
                is = null;
            }
        }
        String msg = "Registering Product Specifications from productListSource=" + this.productSpecList.getProductListSource();
        List<ProductMetadata> prodSpecList = this.productSpecList.getProductSpecList();
        for (ProductMetadata pmeta : prodSpecList) {
            this.productPublisher.addProductDescription(pmeta);
            msg = msg + "\nSpecification List Registered Product Specification for productId=" + pmeta.getProductId();
        }
        System.out.println(msg);
        LOG.info(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterSpecificationList() {
        if (this.productPublisher != null) {
            try {
                System.out.println("Unregistering Product Specifications from productListSource=" + this.productSpecList.getProductListSource());
                LOG.info("Specification List Unregistering Product Specifications from productListSource=" + this.productSpecList.getProductListSource());
                List<ProductMetadata> prodSpecList = this.productSpecList.getProductSpecList();
                for (ProductMetadata pmeta : prodSpecList) {
                    boolean unregistered = this.productPublisher.removeProductDescription(pmeta.getProductId());
                    if (unregistered) {
                        System.out.println("Specification List Unregistered Product Specification for productId=" + pmeta.getProductId());
                        LOG.info("Specification List Unregistered Product Specification for productId=" + pmeta.getProductId());
                        continue;
                    }
                    System.out.println("Specification List Already Unregistered Product Specification for productId=" + pmeta.getProductId());
                    LOG.info("Specification List Already Unregistered Product Specification for productId=" + pmeta.getProductId());
                }
            }
            catch (Exception e) {
                System.err.println("Specification List Problem Unregistering Product Specifications from productListSource=" + this.productSpecList.getProductListSource() + "  " + e);
                LOG.error("Specification List Problem Unregistering Product Specifications from productListSource=" + this.productSpecList.getProductListSource() + "  ", (Throwable)e);
            }
            finally {
                this.productPublisher = null;
            }
        }
    }

    @Override
    public ProductMetadata getProductMetadata() {
        return this.productMetadata;
    }

    @Override
    public void setProductMetadata(ProductMetadata productMetadata) {
        if (productMetadata == null) {
            throw new IllegalArgumentException("productMetadata cannot be null");
        }
        this.productMetadata = productMetadata;
    }

    @Override
    public ProductPublisher getProductPublisher() {
        return this.productPublisher;
    }

    @Override
    public void setProductPublisher(ProductPublisher productPublisher) {
        if (productPublisher == null) {
            throw new IllegalArgumentException("productPublisher cannot be null");
        }
        this.productPublisher = productPublisher;
    }

    @Override
    public String getProductMetadataUri() {
        return this.productMetadataUri;
    }

    @Override
    public void setProductMetadataUri(String productMetadataUri) {
        if (productMetadataUri == null) {
            throw new IllegalArgumentException("productMetadataUri cannot be null");
        }
        this.productMetadataUri = productMetadataUri;
    }

    @Override
    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    @Override
    public void setBundleContext(BundleContext bundleContext) {
        if (bundleContext == null) {
            throw new IllegalArgumentException("bundleContext cannot be null");
        }
        this.bundleContext = bundleContext;
    }

    public String getProductSpecListUri() {
        return this.productSpecListUri;
    }

    public void setProductSpecListUri(String productSpecListUri) {
        this.productSpecListUri = productSpecListUri;
    }

    public ProductSpecList getProductSpecList() {
        return this.productSpecList;
    }

    public void setProductSpecList(ProductSpecList productSpecList) {
        this.productSpecList = productSpecList;
    }
}

