/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.karaf.licencepub.cmd;

import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.opennms.karaf.licencemgr.metadata.jaxb.LicenceMetadata;
import org.opennms.karaf.licencemgr.metadata.jaxb.LicenceSpecification;
import org.opennms.karaf.licencepub.LicencePublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(scope="licence-pub", name="getlicencespec", description="Gets the licence metadata for installed licence specification for a given product id")
public class GetLicenceMetadataCommand
extends OsgiCommandSupport {
    private static final Logger LOG = LoggerFactory.getLogger(GetLicenceMetadataCommand.class);
    private LicencePublisher _licencePublisher;
    @Argument(index=0, name="productId", description="productId for which to find specification metadata", required=true, multiValued=false)
    String productId = null;

    public LicencePublisher getLicencePublisher() {
        return this._licencePublisher;
    }

    public void setLicencePublisher(LicencePublisher _licencePublisher) {
        this._licencePublisher = _licencePublisher;
    }

    protected Object doExecute() throws Exception {
        try {
            LicenceSpecification licenceSpecification = this.getLicencePublisher().getLicenceSpec(this.productId);
            if (licenceSpecification == null) {
                System.out.println("licence specification not installed for productId='" + this.productId + "'");
                LOG.info("licence specification not installed for productId='" + this.productId + "'");
            } else {
                LicenceMetadata licenceMetadata = licenceSpecification.getLicenceMetadataSpec();
                String metadatastr = licenceMetadata == null ? "null" : licenceMetadata.toXml();
                System.out.println("  productId='" + this.productId + "'\n      licenceMetadataSpec='" + metadatastr + "'\n");
                LOG.info("  productId='" + this.productId + "'\n      licenceMetadataSpec='" + metadatastr + "'\n");
            }
        }
        catch (Exception e) {
            System.err.println("Error getting licence specification. Exception=" + e);
            LOG.error("Error getting licence specification. Exception=" + e);
        }
        return null;
    }
}

