/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.karaf.licencepub.cmd;

import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.opennms.karaf.licencepub.LicencePublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(scope="licence-pub", name="createlicence", description="Creates a new licence for given metadata xml (surround xml in 'quotes')")
public class CreateLicenceCommand
extends OsgiCommandSupport {
    private static final Logger LOG = LoggerFactory.getLogger(CreateLicenceCommand.class);
    private LicencePublisher _licencePublisher;
    @Argument(index=0, name="licenceMetadataXml", description="xml encoded licence metadata including productId", required=true, multiValued=false)
    String licenceMetadataXml = null;

    public LicencePublisher getLicencePublisher() {
        return this._licencePublisher;
    }

    public void setLicencePublisher(LicencePublisher _licencePublisher) {
        this._licencePublisher = _licencePublisher;
    }

    protected Object doExecute() throws Exception {
        try {
            String licenceInstanceStr = this.getLicencePublisher().createLicenceInstanceStr(this.licenceMetadataXml);
            System.out.println("Created licence instance. licenceInstanceStr='" + licenceInstanceStr + "'");
            LOG.info("Created licence instance. licenceInstanceStr='" + licenceInstanceStr + "'");
        }
        catch (Exception e) {
            System.err.println("Error Creating licence. Exception=" + e);
            LOG.error("Error Creating licence. Exception=", (Throwable)e);
        }
        return null;
    }
}

