/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.karaf.licencepub;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.opennms.karaf.licencemgr.metadata.Licence;
import org.opennms.karaf.licencemgr.metadata.jaxb.LicenceEntry;
import org.opennms.karaf.licencemgr.metadata.jaxb.LicenceList;
import org.opennms.karaf.licencemgr.metadata.jaxb.LicenceMetadata;
import org.opennms.karaf.licencemgr.metadata.jaxb.LicenceMetadataList;
import org.opennms.karaf.licencemgr.metadata.jaxb.LicenceSpecification;
import org.opennms.karaf.licencemgr.metadata.jaxb.OptionMetadata;
import org.opennms.karaf.licencepub.LicencePublisher;

public class LicencePublisherImpl
implements LicencePublisher {
    private SortedMap<String, LicenceSpecification> licenceSpecMap = new TreeMap<String, LicenceSpecification>();

    @Override
    public synchronized void addLicenceSpec(LicenceSpecification licenceSpec) {
        if (licenceSpec == null) {
            throw new IllegalArgumentException("licenceSpec cannot be null");
        }
        this.licenceSpecMap.put(licenceSpec.getProductId(), licenceSpec);
    }

    @Override
    public synchronized boolean removeLicenceSpec(String productId) {
        if (productId == null) {
            throw new IllegalArgumentException("productId cannot be null");
        }
        if (!this.licenceSpecMap.containsKey(productId)) {
            return false;
        }
        this.licenceSpecMap.remove(productId);
        return true;
    }

    @Override
    public synchronized LicenceSpecification getLicenceSpec(String productId) {
        if (productId == null) {
            throw new IllegalArgumentException("productId cannot be null");
        }
        return (LicenceSpecification)this.licenceSpecMap.get(productId);
    }

    @Override
    public synchronized Map<String, LicenceSpecification> getLicenceSpecMap() {
        return new TreeMap<String, LicenceSpecification>(this.licenceSpecMap);
    }

    @Override
    public synchronized void deleteLicenceSpecifications() {
        this.licenceSpecMap.clear();
    }

    @Override
    public synchronized String createLicenceInstanceStr(LicenceMetadata createLicenceMetadata) throws IllegalArgumentException {
        if (createLicenceMetadata == null) {
            throw new IllegalArgumentException("licenceMetadata cannot be null");
        }
        String productId = createLicenceMetadata.getProductId();
        if (!this.licenceSpecMap.containsKey(productId)) {
            throw new IllegalArgumentException("no Licence Specification exists for productId=" + productId);
        }
        LicenceSpecification licenceSpec = (LicenceSpecification)this.licenceSpecMap.get(productId);
        LicenceMetadata metadataSpec = licenceSpec.getLicenceMetadataSpec();
        if (!metadataSpec.getLicensor().equals(createLicenceMetadata.getLicensor())) {
            throw new IllegalArgumentException("createLicenceMetadata licensor='" + createLicenceMetadata.getLicensor() + "' is different from Licence Specification licensor='" + metadataSpec.getLicensor() + "' for productId=" + productId);
        }
        Integer maxSizeSystemIds = null;
        try {
            maxSizeSystemIds = createLicenceMetadata.getMaxSizeSystemIds() == null ? null : Integer.valueOf(Integer.parseInt(createLicenceMetadata.getMaxSizeSystemIds()));
        }
        catch (Exception e) {
            throw new RuntimeException("the maxSizeSystemIds '" + createLicenceMetadata.getMaxSizeSystemIds() + "' cannot be parsed as int in licence for productId='" + createLicenceMetadata.getProductId() + "'", e);
        }
        if (maxSizeSystemIds != null) {
            if (maxSizeSystemIds == 0 && createLicenceMetadata.getSystemIds().size() > 0) {
                throw new IllegalArgumentException("createLicenceMetadata maxSizeSystemIds= 0 but number of systemIds defined is greater than 0 in licence for productId=" + productId);
            }
            if (maxSizeSystemIds < createLicenceMetadata.getSystemIds().size()) {
                throw new IllegalArgumentException("createLicenceMetadata maxSizeSystemIds is less than the number of systemIds defined in licence for productId=" + productId);
            }
        }
        Set<OptionMetadata> specOptions = metadataSpec.getOptions();
        Set<OptionMetadata> licenceOptions = createLicenceMetadata.getOptions();
        if (specOptions.size() != licenceOptions.size()) {
            throw new IllegalArgumentException("licenceMetadata options do not match specification for productId=" + productId);
        }
        HashSet<String> specOptionNames = new HashSet<String>();
        for (OptionMetadata option : specOptions) {
            specOptionNames.add(option.getName());
        }
        for (OptionMetadata option : licenceOptions) {
            if (specOptionNames.contains(option.getName())) continue;
            throw new IllegalArgumentException("licenceMetadata option name=" + option.getName() + " is not in specification for productId=" + productId);
        }
        Licence licence = new Licence(createLicenceMetadata, licenceSpec.getPublicKeyStr(), licenceSpec.getAesSecretKeyStr());
        return licence.getLicenceStrPlusCrc();
    }

    @Override
    public synchronized String createLicenceInstanceStr(String licenceMetadataXml) {
        if (licenceMetadataXml == null) {
            throw new IllegalArgumentException("licenceMetadataXml cannot be null");
        }
        LicenceMetadata licenceMetadata = new LicenceMetadata();
        licenceMetadata.fromXml(licenceMetadataXml);
        return this.createLicenceInstanceStr(licenceMetadata);
    }

    @Override
    public LicenceList createMultiLicences(LicenceMetadataList licenceMetadataList) {
        if (licenceMetadataList == null) {
            throw new IllegalArgumentException("licenceMetadataXml cannot be null");
        }
        LicenceList licenceStrings = new LicenceList();
        for (LicenceMetadata licenceMetadata : licenceMetadataList.getLicenceMetadataList()) {
            try {
                String licenceStr = this.createLicenceInstanceStr(licenceMetadata);
                LicenceEntry licenceEntry = new LicenceEntry();
                licenceEntry.setProductId(licenceMetadata.getProductId());
                licenceEntry.setLicenceStr(licenceStr);
                licenceStrings.getLicenceList().add(licenceEntry);
            }
            catch (Exception e) {
                throw new RuntimeException("problem creating licences for licence metadata list", e);
            }
        }
        return licenceStrings;
    }
}

