/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.karaf.licencemgr.rest.impl;

import java.util.Date;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.opennms.karaf.licencemgr.LicenceService;
import org.opennms.karaf.licencemgr.metadata.Licence;
import org.opennms.karaf.licencemgr.metadata.jaxb.ErrorMessage;
import org.opennms.karaf.licencemgr.metadata.jaxb.LicenceEntry;
import org.opennms.karaf.licencemgr.metadata.jaxb.LicenceList;
import org.opennms.karaf.licencemgr.metadata.jaxb.LicenceMetadata;
import org.opennms.karaf.licencemgr.metadata.jaxb.ReplyMessage;
import org.opennms.karaf.licencemgr.rest.LicenceServiceRest;
import org.opennms.karaf.licencemgr.rest.impl.ServiceLoader;

@Path(value="/licence-mgr")
public class LicenceServiceRestImpl
implements LicenceServiceRest {
    @Override
    @GET
    @Path(value="/addlicence")
    @Produces(value={"application/xml"})
    public Response addLicence(@QueryParam(value="licence") String licence) {
        String productId;
        LicenceService licenceService = ServiceLoader.getLicenceService();
        if (licenceService == null) {
            throw new RuntimeException("ServiceLoader.getLicenceService() cannot be null.");
        }
        LicenceMetadata licenceMetadata = null;
        try {
            if (licence == null) {
                throw new RuntimeException("Licence cannot be null.");
            }
            licenceMetadata = licenceService.addLicence(licence);
        }
        catch (Exception exception) {
            return Response.status((int)400).entity((Object)new ErrorMessage(400, 0, "Unable to add licence", null, exception)).build();
        }
        ReplyMessage reply = new ReplyMessage();
        try {
            productId = Licence.getUnverifiedMetadata(licence).getProductId();
        }
        catch (Exception e) {
            throw new RuntimeException("cannot decode licence string", e);
        }
        reply.setReplyComment("Successfully added licence instance for productId=" + productId);
        reply.setProductId(productId);
        reply.setLicenceMetadata(licenceMetadata);
        return Response.status((int)200).entity((Object)reply).build();
    }

    @Override
    @GET
    @Path(value="/removelicence")
    @Produces(value={"application/xml"})
    public Response removeLicence(@QueryParam(value="productId") String productId) {
        LicenceService licenceService = ServiceLoader.getLicenceService();
        if (licenceService == null) {
            throw new RuntimeException("ServiceLoader.getLicenceService() cannot be null.");
        }
        Boolean removed = null;
        try {
            if (productId == null) {
                throw new RuntimeException("productId cannot be null.");
            }
            removed = licenceService.removeLicence(productId);
            String devMessage = null;
            if (!removed.booleanValue()) {
                return Response.status((int)400).entity((Object)new ErrorMessage(400, 0, "Licence not found to remove for productId=" + productId, null, devMessage)).build();
            }
        }
        catch (Exception exception) {
            return Response.status((int)400).entity((Object)new ErrorMessage(400, 0, "Unable to remove licence", null, exception)).build();
        }
        ReplyMessage reply = new ReplyMessage();
        reply.setReplyComment("Licence successfully removed for productId=" + productId);
        return Response.status((int)200).entity((Object)reply).build();
    }

    @Override
    @GET
    @Path(value="/getlicence")
    @Produces(value={"application/xml"})
    public Response getLicence(@QueryParam(value="productId") String productId) {
        LicenceService licenceService = ServiceLoader.getLicenceService();
        if (licenceService == null) {
            throw new RuntimeException("ServiceLoader.getLicenceService() cannot be null.");
        }
        String licence = null;
        try {
            if (productId == null) {
                throw new RuntimeException("productId cannot be null.");
            }
            licence = licenceService.getLicence(productId);
            String devMessage = null;
            if (licence == null) {
                return Response.status((int)400).entity((Object)new ErrorMessage(400, 0, "Licence not found for productId=" + productId, null, devMessage)).build();
            }
        }
        catch (Exception exception) {
            return Response.status((int)400).entity((Object)new ErrorMessage(400, 0, "cannot get licence", null, exception)).build();
        }
        ReplyMessage reply = new ReplyMessage();
        reply.setReplyComment("Licence Specification found for productId=" + productId);
        reply.setLicence(licence);
        return Response.status((int)200).entity((Object)reply).build();
    }

    @Override
    @GET
    @Path(value="/isauthenticated")
    @Produces(value={"application/xml"})
    public Response isAuthenticatedProductId(@QueryParam(value="productId") String productId) {
        LicenceService licenceService = ServiceLoader.getLicenceService();
        if (licenceService == null) {
            throw new RuntimeException("ServiceLoader.getLicenceService() cannot be null.");
        }
        Long daysUntilExpiry = null;
        String licence = null;
        boolean isAuthenticated = false;
        try {
            if (productId == null) {
                throw new RuntimeException("productId cannot be null.");
            }
            licence = licenceService.getLicence(productId);
            if (licence == null) {
                String devMessage = null;
                return Response.status((int)400).entity((Object)new ErrorMessage(400, 0, "Licence not installed for productId=" + productId, null, devMessage)).build();
            }
            daysUntilExpiry = Licence.daysToExpiry(licence, new Date());
            isAuthenticated = licenceService.isAuthenticatedProductId(productId);
        }
        catch (Exception exception) {
            return Response.status((int)400).entity((Object)new ErrorMessage(400, 0, "Problem finding if productId is authenticated", null, exception)).build();
        }
        ReplyMessage reply = new ReplyMessage();
        reply.setIsAuthenticated(isAuthenticated);
        reply.setProductId(productId);
        if (isAuthenticated) {
            reply.setReplyComment("Licence is authenticated for productId=" + productId);
        } else {
            reply.setReplyComment("Licence is not authenticated for productId=" + productId);
        }
        if (daysUntilExpiry != null) {
            reply.setDaysUntilExpiry(daysUntilExpiry.toString());
        }
        return Response.status((int)200).entity((Object)reply).build();
    }

    @Override
    @GET
    @Path(value="/list")
    @Produces(value={"application/xml"})
    public Response getLicenceMap() {
        LicenceService licenceService = ServiceLoader.getLicenceService();
        if (licenceService == null) {
            throw new RuntimeException("ServiceLoader.getLicenceService() cannot be null.");
        }
        Map<String, String> licenceMap = null;
        try {
            licenceMap = licenceService.getLicenceMap();
        }
        catch (Exception exception) {
            return Response.status((int)400).entity((Object)new ErrorMessage(400, 0, "cannot get licence map", null, exception)).build();
        }
        LicenceList licenceListResponse = new LicenceList();
        for (Map.Entry<String, String> entry : licenceMap.entrySet()) {
            LicenceEntry licenceEntry = new LicenceEntry();
            licenceEntry.setProductId(entry.getKey());
            licenceEntry.setLicenceStr(entry.getValue());
            licenceListResponse.getLicenceList().add(licenceEntry);
        }
        return Response.status((int)200).entity((Object)licenceListResponse).build();
    }

    @Override
    @GET
    @Path(value="/listforsystemid")
    @Produces(value={"application/xml"})
    public Response getLicenceMapForSystemId(@QueryParam(value="systemId") String systemId) {
        LicenceService licenceService = ServiceLoader.getLicenceService();
        if (licenceService == null) {
            throw new RuntimeException("ServiceLoader.getLicenceService() cannot be null.");
        }
        Map<String, String> licenceMap = null;
        try {
            if (systemId == null) {
                throw new RuntimeException("parameter systemId cannot be null.");
            }
            licenceMap = licenceService.getLicenceMapForSystemId(systemId);
        }
        catch (Exception exception) {
            return Response.status((int)400).entity((Object)new ErrorMessage(400, 0, "cannot get licence map", null, exception)).build();
        }
        LicenceList licenceListResponse = new LicenceList();
        for (Map.Entry<String, String> entry : licenceMap.entrySet()) {
            LicenceEntry licenceEntry = new LicenceEntry();
            licenceEntry.setProductId(entry.getKey());
            licenceEntry.setLicenceStr(entry.getValue());
            licenceListResponse.getLicenceList().add(licenceEntry);
        }
        return Response.status((int)200).entity((Object)licenceListResponse).build();
    }

    @Override
    @GET
    @Path(value="/clearlicences")
    @Produces(value={"application/xml"})
    public Response deleteLicences(@QueryParam(value="confirm") String confirm) {
        LicenceService licenceService = ServiceLoader.getLicenceService();
        if (licenceService == null) {
            throw new RuntimeException("ServiceLoader.getLicenceService() cannot be null.");
        }
        try {
            if (!"true".equals(confirm)) {
                throw new IllegalArgumentException("Will only delete licences if paramater confirm=true");
            }
            licenceService.deleteLicences();
        }
        catch (Exception exception) {
            return Response.status((int)400).entity((Object)new ErrorMessage(400, 0, "cannot delete licences", null, exception)).build();
        }
        ReplyMessage reply = new ReplyMessage();
        reply.setReplyComment("All Licences removed");
        return Response.status((int)200).entity((Object)reply).build();
    }

    @Override
    @GET
    @Path(value="getsystemid")
    @Produces(value={"application/xml"})
    public Response getSystemId() {
        LicenceService licenceService = ServiceLoader.getLicenceService();
        if (licenceService == null) {
            throw new RuntimeException("ServiceLoader.getLicenceService() cannot be null.");
        }
        String systemId = null;
        try {
            systemId = licenceService.getSystemId();
        }
        catch (Exception exception) {
            return Response.status((int)400).entity((Object)new ErrorMessage(400, 0, "cannot get systemId", null, exception)).build();
        }
        ReplyMessage reply = new ReplyMessage();
        reply.setReplyComment("Returned systemId for this system");
        reply.setSystemId(systemId);
        return Response.status((int)200).entity((Object)reply).build();
    }

    @Override
    @GET
    @Path(value="setsystemid")
    @Produces(value={"application/xml"})
    public Response setSystemId(@QueryParam(value="systemId") String systemId) {
        LicenceService licenceService = ServiceLoader.getLicenceService();
        if (licenceService == null) {
            throw new RuntimeException("ServiceLoader.getLicenceService() cannot be null.");
        }
        try {
            if (systemId == null) {
                throw new RuntimeException("systemId cannot be null.");
            }
            licenceService.setSystemId(systemId);
        }
        catch (Exception exception) {
            return Response.status((int)400).entity((Object)new ErrorMessage(400, 0, "cannot set systemId", null, exception)).build();
        }
        ReplyMessage reply = new ReplyMessage();
        reply.setReplyComment("Set systemId for this system");
        reply.setSystemId(systemId);
        return Response.status((int)200).entity((Object)reply).build();
    }

    @Override
    @GET
    @Path(value="/makesystemid")
    @Produces(value={"application/xml"})
    public Response makeSystemInstance() {
        LicenceService licenceService = ServiceLoader.getLicenceService();
        if (licenceService == null) {
            throw new RuntimeException("ServiceLoader.getLicenceService() cannot be null.");
        }
        String systemId = null;
        try {
            systemId = licenceService.makeSystemInstance();
        }
        catch (Exception exception) {
            return Response.status((int)400).entity((Object)new ErrorMessage(400, 0, "cannot make system instance", null, exception)).build();
        }
        ReplyMessage reply = new ReplyMessage();
        reply.setReplyComment("New systemId created and installed for this system");
        reply.setSystemId(systemId);
        return Response.status((int)200).entity((Object)reply).build();
    }

    @Override
    @GET
    @Path(value="/checksumforstring")
    @Produces(value={"application/xml"})
    public Response checksumForString(@QueryParam(value="string") String string) {
        LicenceService licenceService = ServiceLoader.getLicenceService();
        if (licenceService == null) {
            throw new RuntimeException("ServiceLoader.getLicenceService() cannot be null.");
        }
        String checksum = null;
        try {
            if (string == null) {
                throw new RuntimeException("string cannot be null.");
            }
            checksum = licenceService.checksumForString(string);
        }
        catch (Exception exception) {
            return Response.status((int)400).entity((Object)new ErrorMessage(400, 0, "cannot generate checksum for string", null, exception)).build();
        }
        ReplyMessage reply = new ReplyMessage();
        reply.setReplyComment("New checksum added to string");
        reply.setChecksum(checksum);
        return Response.status((int)200).entity((Object)reply).build();
    }
}

